/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.support;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.dromara.dynamictp.common.entity.NotifyItem;
import org.dromara.dynamictp.core.aware.AwareManager;
import org.dromara.dynamictp.core.aware.TaskEnhanceAware;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.dromara.dynamictp.core.notifier.capture.CapturedExecutor;
import org.dromara.dynamictp.core.notifier.manager.AlarmManager;
import org.dromara.dynamictp.core.support.ExecutorAdapter;
import org.dromara.dynamictp.core.support.ThreadPoolExecutorAdapter;
import org.dromara.dynamictp.core.support.ThreadPoolStatProvider;
import org.dromara.dynamictp.core.support.task.wrapper.TaskWrapper;
import org.springframework.beans.BeanUtils;

public class ExecutorWrapper {
    private String threadPoolName;
    private String threadPoolAliasName;
    private ExecutorAdapter<?> executor;
    private List<NotifyItem> notifyItems;
    private List<String> platformIds;
    private boolean notifyEnabled = true;
    private ThreadPoolStatProvider threadPoolStatProvider;
    private Set<String> awareNames = Sets.newHashSet();

    private ExecutorWrapper() {
    }

    public ExecutorWrapper(DtpExecutor executor) {
        this.threadPoolName = executor.getThreadPoolName();
        this.threadPoolAliasName = executor.getThreadPoolAliasName();
        this.executor = executor;
        this.notifyItems = executor.getNotifyItems();
        this.notifyEnabled = executor.isNotifyEnabled();
        this.platformIds = executor.getPlatformIds();
        this.awareNames = executor.getAwareNames();
        this.threadPoolStatProvider = ThreadPoolStatProvider.of(this);
    }

    public ExecutorWrapper(String threadPoolName, Executor executor) {
        this.threadPoolName = threadPoolName;
        if (executor instanceof ThreadPoolExecutor) {
            this.executor = new ThreadPoolExecutorAdapter((ThreadPoolExecutor)executor);
        } else if (executor instanceof ExecutorAdapter) {
            this.executor = (ExecutorAdapter)executor;
        } else {
            throw new IllegalArgumentException("unsupported Executor type !");
        }
        this.notifyItems = NotifyItem.getAllNotifyItems();
        AlarmManager.initAlarm(threadPoolName, this.notifyItems);
        this.threadPoolStatProvider = ThreadPoolStatProvider.of(this);
    }

    public static ExecutorWrapper of(DtpExecutor executor) {
        return new ExecutorWrapper(executor);
    }

    public ExecutorWrapper capture() {
        ExecutorWrapper executorWrapper = new ExecutorWrapper();
        BeanUtils.copyProperties((Object)this, (Object)executorWrapper);
        executorWrapper.executor = new CapturedExecutor(this.getExecutor());
        return executorWrapper;
    }

    public void initialize() {
        if (this.isDtpExecutor()) {
            DtpExecutor dtpExecutor = (DtpExecutor)this.getExecutor();
            dtpExecutor.initialize();
            AwareManager.register(this);
        } else if (this.isThreadPoolExecutor()) {
            AwareManager.register(this);
        }
    }

    public boolean isDtpExecutor() {
        return this.executor instanceof DtpExecutor;
    }

    public boolean isThreadPoolExecutor() {
        return this.executor instanceof ThreadPoolExecutorAdapter;
    }

    public void setTaskWrappers(List<TaskWrapper> taskWrappers) {
        if (this.executor.getOriginal() instanceof TaskEnhanceAware) {
            ((TaskEnhanceAware)this.executor.getOriginal()).setTaskWrappers(taskWrappers);
        }
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public String getThreadPoolAliasName() {
        return this.threadPoolAliasName;
    }

    public ExecutorAdapter<?> getExecutor() {
        return this.executor;
    }

    public List<NotifyItem> getNotifyItems() {
        return this.notifyItems;
    }

    public List<String> getPlatformIds() {
        return this.platformIds;
    }

    public boolean isNotifyEnabled() {
        return this.notifyEnabled;
    }

    public ThreadPoolStatProvider getThreadPoolStatProvider() {
        return this.threadPoolStatProvider;
    }

    public Set<String> getAwareNames() {
        return this.awareNames;
    }

    public void setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
    }

    public void setThreadPoolAliasName(String threadPoolAliasName) {
        this.threadPoolAliasName = threadPoolAliasName;
    }

    public void setExecutor(ExecutorAdapter<?> executor) {
        this.executor = executor;
    }

    public void setNotifyItems(List<NotifyItem> notifyItems) {
        this.notifyItems = notifyItems;
    }

    public void setPlatformIds(List<String> platformIds) {
        this.platformIds = platformIds;
    }

    public void setNotifyEnabled(boolean notifyEnabled) {
        this.notifyEnabled = notifyEnabled;
    }

    public void setThreadPoolStatProvider(ThreadPoolStatProvider threadPoolStatProvider) {
        this.threadPoolStatProvider = threadPoolStatProvider;
    }

    public void setAwareNames(Set<String> awareNames) {
        this.awareNames = awareNames;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutorWrapper)) {
            return false;
        }
        ExecutorWrapper other = (ExecutorWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNotifyEnabled() != other.isNotifyEnabled()) {
            return false;
        }
        String this$threadPoolName = this.getThreadPoolName();
        String other$threadPoolName = other.getThreadPoolName();
        if (this$threadPoolName == null ? other$threadPoolName != null : !this$threadPoolName.equals(other$threadPoolName)) {
            return false;
        }
        String this$threadPoolAliasName = this.getThreadPoolAliasName();
        String other$threadPoolAliasName = other.getThreadPoolAliasName();
        if (this$threadPoolAliasName == null ? other$threadPoolAliasName != null : !this$threadPoolAliasName.equals(other$threadPoolAliasName)) {
            return false;
        }
        ExecutorAdapter<?> this$executor = this.getExecutor();
        ExecutorAdapter<?> other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        List<NotifyItem> this$notifyItems = this.getNotifyItems();
        List<NotifyItem> other$notifyItems = other.getNotifyItems();
        if (this$notifyItems == null ? other$notifyItems != null : !((Object)this$notifyItems).equals(other$notifyItems)) {
            return false;
        }
        List<String> this$platformIds = this.getPlatformIds();
        List<String> other$platformIds = other.getPlatformIds();
        if (this$platformIds == null ? other$platformIds != null : !((Object)this$platformIds).equals(other$platformIds)) {
            return false;
        }
        ThreadPoolStatProvider this$threadPoolStatProvider = this.getThreadPoolStatProvider();
        ThreadPoolStatProvider other$threadPoolStatProvider = other.getThreadPoolStatProvider();
        if (this$threadPoolStatProvider == null ? other$threadPoolStatProvider != null : !this$threadPoolStatProvider.equals(other$threadPoolStatProvider)) {
            return false;
        }
        Set<String> this$awareNames = this.getAwareNames();
        Set<String> other$awareNames = other.getAwareNames();
        return !(this$awareNames == null ? other$awareNames != null : !((Object)this$awareNames).equals(other$awareNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExecutorWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNotifyEnabled() ? 79 : 97);
        String $threadPoolName = this.getThreadPoolName();
        result = result * 59 + ($threadPoolName == null ? 43 : $threadPoolName.hashCode());
        String $threadPoolAliasName = this.getThreadPoolAliasName();
        result = result * 59 + ($threadPoolAliasName == null ? 43 : $threadPoolAliasName.hashCode());
        ExecutorAdapter<?> $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        List<NotifyItem> $notifyItems = this.getNotifyItems();
        result = result * 59 + ($notifyItems == null ? 43 : ((Object)$notifyItems).hashCode());
        List<String> $platformIds = this.getPlatformIds();
        result = result * 59 + ($platformIds == null ? 43 : ((Object)$platformIds).hashCode());
        ThreadPoolStatProvider $threadPoolStatProvider = this.getThreadPoolStatProvider();
        result = result * 59 + ($threadPoolStatProvider == null ? 43 : $threadPoolStatProvider.hashCode());
        Set<String> $awareNames = this.getAwareNames();
        result = result * 59 + ($awareNames == null ? 43 : ((Object)$awareNames).hashCode());
        return result;
    }

    public String toString() {
        return "ExecutorWrapper(threadPoolName=" + this.getThreadPoolName() + ", threadPoolAliasName=" + this.getThreadPoolAliasName() + ", executor=" + this.getExecutor() + ", notifyItems=" + this.getNotifyItems() + ", platformIds=" + this.getPlatformIds() + ", notifyEnabled=" + this.isNotifyEnabled() + ", threadPoolStatProvider=" + this.getThreadPoolStatProvider() + ", awareNames=" + this.getAwareNames() + ")";
    }
}

