/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.support;

import com.alibaba.ttl.TtlRunnable;
import com.alibaba.ttl.threadpool.TtlExecutors;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.dynamictp.common.constant.DynamicTpConst;
import org.dromara.dynamictp.common.em.QueueTypeEnum;
import org.dromara.dynamictp.common.entity.NotifyItem;
import org.dromara.dynamictp.common.queue.VariableLinkedBlockingQueue;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.dromara.dynamictp.core.executor.NamedThreadFactory;
import org.dromara.dynamictp.core.executor.OrderedDtpExecutor;
import org.dromara.dynamictp.core.executor.ScheduledDtpExecutor;
import org.dromara.dynamictp.core.executor.eager.EagerDtpExecutor;
import org.dromara.dynamictp.core.executor.eager.TaskQueue;
import org.dromara.dynamictp.core.executor.priority.PriorityDtpExecutor;
import org.dromara.dynamictp.core.reject.RejectHandlerGetter;
import org.dromara.dynamictp.core.support.task.wrapper.TaskWrapper;
import org.springframework.util.Assert;

public class ThreadPoolBuilder {
    private String threadPoolName = "DynamicTp";
    private int corePoolSize = 1;
    private int maximumPoolSize = DynamicTpConst.AVAILABLE_PROCESSORS;
    private long keepAliveTime = 60L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private BlockingQueue<Runnable> workQueue = new VariableLinkedBlockingQueue(1024);
    private int queueCapacity = 1024;
    private int maxFreeMemory = 16;
    private RejectedExecutionHandler rejectedExecutionHandler = new ThreadPoolExecutor.AbortPolicy();
    private ThreadFactory threadFactory = new NamedThreadFactory("dtp");
    private boolean allowCoreThreadTimeOut = false;
    private boolean dynamic = true;
    private boolean waitForTasksToCompleteOnShutdown = true;
    private int awaitTerminationSeconds = 3;
    private boolean eager = false;
    private boolean ordered = false;
    private boolean scheduled = false;
    private boolean priority = false;
    private boolean preStartAllCoreThreads = false;
    private boolean rejectEnhanced = true;
    private boolean notifyEnabled = true;
    private long runTimeout = 0L;
    private boolean tryInterrupt = false;
    private long queueTimeout = 0L;
    private final List<TaskWrapper> taskWrappers = Lists.newArrayList();
    private List<NotifyItem> notifyItems = NotifyItem.getAllNotifyItems();
    private List<String> platformIds = Lists.newArrayList();

    private ThreadPoolBuilder() {
    }

    public static ThreadPoolBuilder newBuilder() {
        return new ThreadPoolBuilder();
    }

    public ThreadPoolBuilder threadPoolName(String poolName) {
        this.threadPoolName = poolName;
        return this;
    }

    public ThreadPoolBuilder corePoolSize(int corePoolSize) {
        if (corePoolSize >= 0) {
            this.corePoolSize = corePoolSize;
        }
        return this;
    }

    public ThreadPoolBuilder maximumPoolSize(int maximumPoolSize) {
        if (maximumPoolSize > 0) {
            this.maximumPoolSize = maximumPoolSize;
        }
        return this;
    }

    public ThreadPoolBuilder keepAliveTime(long keepAliveTime) {
        if (keepAliveTime > 0L) {
            this.keepAliveTime = keepAliveTime;
        }
        return this;
    }

    public ThreadPoolBuilder timeUnit(TimeUnit timeUnit) {
        if (timeUnit != null) {
            this.timeUnit = timeUnit;
        }
        return this;
    }

    public ThreadPoolBuilder workQueue(String queueName, Integer capacity, Boolean fair, Integer maxFreeMemory) {
        if (StringUtils.isNotBlank((CharSequence)queueName)) {
            this.workQueue = QueueTypeEnum.buildLbq((String)queueName, (int)(capacity != null ? capacity : this.queueCapacity), (fair != null && fair != false ? 1 : 0) != 0, (int)(maxFreeMemory != null ? maxFreeMemory : this.maxFreeMemory));
        }
        return this;
    }

    public ThreadPoolBuilder workQueue(String queueName, Integer capacity, Boolean fair) {
        if (StringUtils.isNotBlank((CharSequence)queueName)) {
            this.workQueue = QueueTypeEnum.buildLbq((String)queueName, (int)(capacity != null ? capacity : this.queueCapacity), (fair != null && fair != false ? 1 : 0) != 0, (int)this.maxFreeMemory);
        }
        return this;
    }

    public ThreadPoolBuilder workQueue(String queueName, Integer capacity) {
        if (StringUtils.isNotBlank((CharSequence)queueName)) {
            this.workQueue = QueueTypeEnum.buildLbq((String)queueName, (int)(capacity != null ? capacity : this.queueCapacity), (boolean)false, (int)this.maxFreeMemory);
        }
        return this;
    }

    public ThreadPoolBuilder queueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
        return this;
    }

    public ThreadPoolBuilder maxFreeMemory(int maxFreeMemory) {
        this.maxFreeMemory = maxFreeMemory;
        return this;
    }

    public ThreadPoolBuilder rejectedExecutionHandler(String rejectedName) {
        if (StringUtils.isNotBlank((CharSequence)rejectedName)) {
            this.rejectedExecutionHandler = RejectHandlerGetter.buildRejectedHandler(rejectedName);
        }
        return this;
    }

    public ThreadPoolBuilder rejectedExecutionHandler(RejectedExecutionHandler handler) {
        if (Objects.nonNull(this.rejectedExecutionHandler)) {
            this.rejectedExecutionHandler = handler;
        }
        return this;
    }

    public ThreadPoolBuilder threadFactory(String prefix) {
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            this.threadFactory = new NamedThreadFactory(prefix);
        }
        return this;
    }

    public ThreadPoolBuilder allowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
        return this;
    }

    public ThreadPoolBuilder dynamic(boolean dynamic) {
        this.dynamic = dynamic;
        return this;
    }

    public ThreadPoolBuilder awaitTerminationSeconds(int awaitTerminationSeconds) {
        this.awaitTerminationSeconds = awaitTerminationSeconds;
        return this;
    }

    public ThreadPoolBuilder waitForTasksToCompleteOnShutdown(boolean waitForTasksToCompleteOnShutdown) {
        this.waitForTasksToCompleteOnShutdown = waitForTasksToCompleteOnShutdown;
        return this;
    }

    @Deprecated
    public ThreadPoolBuilder eager(boolean eager) {
        this.checkExecutorType();
        this.eager = eager;
        return this;
    }

    @Deprecated
    public ThreadPoolBuilder ordered(boolean ordered) {
        this.checkExecutorType();
        this.ordered = ordered;
        return this;
    }

    @Deprecated
    public ThreadPoolBuilder scheduled(boolean scheduled) {
        this.checkExecutorType();
        this.scheduled = scheduled;
        return this;
    }

    @Deprecated
    public ThreadPoolBuilder priority(boolean priority) {
        this.checkExecutorType();
        this.priority = priority;
        return this;
    }

    public ThreadPoolBuilder eager() {
        this.checkExecutorType();
        this.eager = true;
        return this;
    }

    public ThreadPoolBuilder ordered() {
        this.checkExecutorType();
        this.ordered = true;
        return this;
    }

    public ThreadPoolBuilder scheduled() {
        this.checkExecutorType();
        this.scheduled = true;
        return this;
    }

    public ThreadPoolBuilder priority() {
        this.checkExecutorType();
        this.priority = true;
        return this;
    }

    public ThreadPoolBuilder preStartAllCoreThreads(boolean preStartAllCoreThreads) {
        this.preStartAllCoreThreads = preStartAllCoreThreads;
        return this;
    }

    public ThreadPoolBuilder rejectEnhanced(boolean rejectEnhanced) {
        this.rejectEnhanced = rejectEnhanced;
        return this;
    }

    public ThreadPoolBuilder notifyEnabled(boolean notifyEnabled) {
        this.notifyEnabled = notifyEnabled;
        return this;
    }

    public ThreadPoolBuilder runTimeout(long runTimeout) {
        this.runTimeout = runTimeout;
        return this;
    }

    public ThreadPoolBuilder tryInterrupt(boolean tryInterrupt) {
        this.tryInterrupt = tryInterrupt;
        return this;
    }

    public ThreadPoolBuilder queueTimeout(long queueTimeout) {
        this.queueTimeout = queueTimeout;
        return this;
    }

    public ThreadPoolBuilder taskWrappers(List<TaskWrapper> taskWrappers) {
        this.taskWrappers.addAll(taskWrappers);
        return this;
    }

    public ThreadPoolBuilder taskWrapper(TaskWrapper taskWrapper) {
        this.taskWrappers.add(taskWrapper);
        return this;
    }

    public ThreadPoolBuilder notifyItems(List<NotifyItem> notifyItemList) {
        if (CollectionUtils.isNotEmpty(notifyItemList)) {
            this.notifyItems = notifyItemList;
        }
        return this;
    }

    public ThreadPoolBuilder platformIds(List<String> platformIds) {
        if (CollectionUtils.isNotEmpty(platformIds)) {
            this.platformIds = platformIds;
        }
        return this;
    }

    public ThreadPoolExecutor build() {
        if (this.dynamic) {
            return this.buildDtpExecutor(this);
        }
        return this.buildCommonExecutor(this);
    }

    public DtpExecutor buildDynamic() {
        return this.buildDtpExecutor(this);
    }

    public ThreadPoolExecutor buildCommon() {
        return this.buildCommonExecutor(this);
    }

    public ScheduledExecutorService buildScheduled() {
        this.scheduled = true;
        if (this.dynamic) {
            return (ScheduledDtpExecutor)this.buildDtpExecutor(this);
        }
        return (ScheduledThreadPoolExecutor)this.buildCommonExecutor(this);
    }

    public OrderedDtpExecutor buildOrdered() {
        this.ordered = true;
        return (OrderedDtpExecutor)this.buildDtpExecutor(this);
    }

    public EagerDtpExecutor buildEager() {
        this.eager = true;
        return (EagerDtpExecutor)this.buildDtpExecutor(this);
    }

    public PriorityDtpExecutor buildPriority() {
        this.priority = true;
        return (PriorityDtpExecutor)this.buildDtpExecutor(this);
    }

    public ExecutorService buildWithTtl() {
        if (this.dynamic) {
            this.taskWrappers.add(TtlRunnable::get);
            return this.buildDtpExecutor(this);
        }
        return TtlExecutors.getTtlExecutorService((ExecutorService)this.buildCommonExecutor(this));
    }

    private DtpExecutor buildDtpExecutor(ThreadPoolBuilder builder) {
        Assert.notNull((Object)builder.threadPoolName, (String)"The thread pool name must not be null.");
        DtpExecutor dtpExecutor = this.createInternal(builder);
        dtpExecutor.setThreadPoolName(builder.threadPoolName);
        dtpExecutor.allowCoreThreadTimeOut(builder.allowCoreThreadTimeOut);
        dtpExecutor.setWaitForTasksToCompleteOnShutdown(builder.waitForTasksToCompleteOnShutdown);
        dtpExecutor.setAwaitTerminationSeconds(builder.awaitTerminationSeconds);
        dtpExecutor.setPreStartAllCoreThreads(builder.preStartAllCoreThreads);
        dtpExecutor.setRejectEnhanced(builder.rejectEnhanced);
        dtpExecutor.setRunTimeout(builder.runTimeout);
        dtpExecutor.setTryInterrupt(builder.tryInterrupt);
        dtpExecutor.setQueueTimeout(builder.queueTimeout);
        dtpExecutor.setTaskWrappers(builder.taskWrappers);
        dtpExecutor.setNotifyItems(builder.notifyItems);
        dtpExecutor.setPlatformIds(builder.platformIds);
        dtpExecutor.setNotifyEnabled(builder.notifyEnabled);
        dtpExecutor.setRejectHandler(builder.rejectedExecutionHandler);
        return dtpExecutor;
    }

    private DtpExecutor createInternal(ThreadPoolBuilder builder) {
        DtpExecutor dtpExecutor;
        if (this.eager) {
            TaskQueue taskQueue = new TaskQueue(builder.queueCapacity);
            dtpExecutor = new EagerDtpExecutor(builder.corePoolSize, builder.maximumPoolSize, builder.keepAliveTime, builder.timeUnit, (BlockingQueue<Runnable>)((Object)taskQueue), builder.threadFactory, builder.rejectedExecutionHandler);
            taskQueue.setExecutor((EagerDtpExecutor)dtpExecutor);
        } else {
            dtpExecutor = this.ordered ? new OrderedDtpExecutor(builder.corePoolSize, builder.maximumPoolSize, builder.keepAliveTime, builder.timeUnit, builder.workQueue, builder.threadFactory, builder.rejectedExecutionHandler) : (this.scheduled ? new ScheduledDtpExecutor(builder.corePoolSize, builder.maximumPoolSize, builder.keepAliveTime, builder.timeUnit, builder.workQueue, builder.threadFactory, builder.rejectedExecutionHandler) : (this.priority ? new PriorityDtpExecutor(builder.corePoolSize, builder.maximumPoolSize, builder.keepAliveTime, builder.timeUnit, new PriorityBlockingQueue<Runnable>(builder.queueCapacity, PriorityDtpExecutor.getRunnableComparator()), builder.threadFactory, builder.rejectedExecutionHandler) : new DtpExecutor(builder.corePoolSize, builder.maximumPoolSize, builder.keepAliveTime, builder.timeUnit, builder.workQueue, builder.threadFactory, builder.rejectedExecutionHandler)));
        }
        return dtpExecutor;
    }

    private ThreadPoolExecutor buildCommonExecutor(ThreadPoolBuilder builder) {
        if (this.scheduled) {
            return new ScheduledThreadPoolExecutor(builder.corePoolSize, builder.threadFactory, builder.rejectedExecutionHandler);
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(builder.corePoolSize, builder.maximumPoolSize, builder.keepAliveTime, builder.timeUnit, builder.workQueue, builder.threadFactory, builder.rejectedExecutionHandler);
        executor.allowCoreThreadTimeOut(builder.allowCoreThreadTimeOut);
        return executor;
    }

    private void checkExecutorType() {
        if (this.eager || this.ordered || this.scheduled || this.priority) {
            throw new IllegalArgumentException("More than one executor type is defined");
        }
    }
}

