/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.support;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.dromara.dynamictp.common.em.QueueTypeEnum;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.dromara.dynamictp.core.support.ThreadPoolBuilder;

public class ThreadPoolCreator {
    private ThreadPoolCreator() {
    }

    public static ThreadPoolExecutor createCommonFast(String threadPrefix) {
        return ThreadPoolBuilder.newBuilder().threadFactory(threadPrefix).buildCommon();
    }

    public static ExecutorService createCommonWithTtl(String threadPrefix) {
        return ThreadPoolBuilder.newBuilder().dynamic(false).threadFactory(threadPrefix).buildWithTtl();
    }

    public static DtpExecutor createDynamicFast(String poolName) {
        return ThreadPoolCreator.createDynamicFast(poolName, poolName);
    }

    public static DtpExecutor createDynamicFast(String poolName, String threadPrefix) {
        return ThreadPoolBuilder.newBuilder().threadPoolName(poolName).threadFactory(threadPrefix).buildDynamic();
    }

    public static ExecutorService createDynamicWithTtl(String poolName) {
        return ThreadPoolCreator.createDynamicWithTtl(poolName, poolName);
    }

    public static ExecutorService createDynamicWithTtl(String poolName, String threadPrefix) {
        return ThreadPoolBuilder.newBuilder().threadPoolName(poolName).threadFactory(threadPrefix).buildWithTtl();
    }

    public static ThreadPoolExecutor newSingleThreadPool(String threadPrefix, int queueCapacity) {
        return ThreadPoolCreator.newFixedThreadPool(threadPrefix, 1, queueCapacity);
    }

    public static ThreadPoolExecutor newFixedThreadPool(String threadPrefix, int poolSize, int queueCapacity) {
        return ThreadPoolBuilder.newBuilder().corePoolSize(poolSize).maximumPoolSize(poolSize).keepAliveTime(0L).workQueue(QueueTypeEnum.VARIABLE_LINKED_BLOCKING_QUEUE.getName(), queueCapacity, null).threadFactory(threadPrefix).buildCommon();
    }

    public static ThreadPoolExecutor newThreadPool(String threadPrefix, int corePoolSize, int maximumPoolSize, int queueCapacity) {
        return ThreadPoolBuilder.newBuilder().corePoolSize(corePoolSize).maximumPoolSize(maximumPoolSize).workQueue(QueueTypeEnum.VARIABLE_LINKED_BLOCKING_QUEUE.getName(), queueCapacity, null).threadFactory(threadPrefix).buildCommon();
    }

    public static ScheduledExecutorService newScheduledThreadPool(String threadPrefix, int corePoolSize) {
        return ThreadPoolBuilder.newBuilder().dynamic(false).corePoolSize(corePoolSize).maximumPoolSize(corePoolSize).threadFactory(threadPrefix).buildScheduled();
    }

    public static ThreadPoolExecutor newExecutorByBlockingCoefficient(float blockingCoefficient) {
        if (blockingCoefficient >= 1.0f || blockingCoefficient < 0.0f) {
            throw new IllegalArgumentException();
        }
        int poolSize = (int)((float)Runtime.getRuntime().availableProcessors() / (1.0f - blockingCoefficient));
        return ThreadPoolBuilder.newBuilder().corePoolSize(poolSize).maximumPoolSize(poolSize).buildCommon();
    }
}

