/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.support;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.dromara.dynamictp.common.spring.ApplicationContextHolder;
import org.dromara.dynamictp.common.timer.HashedWheelTimer;
import org.dromara.dynamictp.common.timer.Timeout;
import org.dromara.dynamictp.common.timer.TimerTask;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.dromara.dynamictp.core.monitor.PerformanceProvider;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.dromara.dynamictp.core.timer.QueueTimeoutTimerTask;
import org.dromara.dynamictp.core.timer.RunTimeoutTimerTask;

public class ThreadPoolStatProvider {
    private final ExecutorWrapper executorWrapper;
    private long runTimeout = 0L;
    private boolean tryInterrupt = false;
    private long queueTimeout = 0L;
    private final LongAdder rejectCount = new LongAdder();
    private final LongAdder runTimeoutCount = new LongAdder();
    private final LongAdder queueTimeoutCount = new LongAdder();
    private final Map<Runnable, SoftReference<Timeout>> runTimeoutMap = new ConcurrentHashMap<Runnable, SoftReference<Timeout>>();
    private final Map<Runnable, SoftReference<Timeout>> queueTimeoutMap = new ConcurrentHashMap<Runnable, SoftReference<Timeout>>();
    private final Map<Runnable, Long> stopWatchMap = new ConcurrentHashMap<Runnable, Long>();
    private final PerformanceProvider performanceProvider = new PerformanceProvider();

    private ThreadPoolStatProvider(ExecutorWrapper executorWrapper) {
        this.executorWrapper = executorWrapper;
    }

    public static ThreadPoolStatProvider of(ExecutorWrapper executorWrapper) {
        ThreadPoolStatProvider provider = new ThreadPoolStatProvider(executorWrapper);
        if (executorWrapper.isDtpExecutor()) {
            DtpExecutor dtpExecutor = (DtpExecutor)executorWrapper.getExecutor();
            provider.setRunTimeout(dtpExecutor.getRunTimeout());
            provider.setQueueTimeout(dtpExecutor.getQueueTimeout());
            provider.setTryInterrupt(dtpExecutor.isTryInterrupt());
        }
        return provider;
    }

    public ExecutorWrapper getExecutorWrapper() {
        return this.executorWrapper;
    }

    public long getRunTimeout() {
        return this.runTimeout;
    }

    public void setRunTimeout(long runTimeout) {
        this.runTimeout = runTimeout;
    }

    public boolean isTryInterrupt() {
        return this.tryInterrupt;
    }

    public void setTryInterrupt(boolean tryInterrupt) {
        this.tryInterrupt = tryInterrupt;
    }

    public long getQueueTimeout() {
        return this.queueTimeout;
    }

    public void setQueueTimeout(long queueTimeout) {
        this.queueTimeout = queueTimeout;
    }

    public long getRejectedTaskCount() {
        return this.rejectCount.sum();
    }

    public void incRejectCount(int count) {
        this.rejectCount.add(count);
    }

    public long getRunTimeoutCount() {
        return this.runTimeoutCount.sum();
    }

    public void incRunTimeoutCount(int count) {
        this.runTimeoutCount.add(count);
    }

    public long getQueueTimeoutCount() {
        return this.queueTimeoutCount.sum();
    }

    public void incQueueTimeoutCount(int count) {
        this.queueTimeoutCount.add(count);
    }

    public void startQueueTimeoutTask(Runnable r) {
        if (this.queueTimeout <= 0L) {
            return;
        }
        HashedWheelTimer timer = (HashedWheelTimer)ApplicationContextHolder.getBean(HashedWheelTimer.class);
        QueueTimeoutTimerTask timerTask = new QueueTimeoutTimerTask(this.executorWrapper, r);
        this.queueTimeoutMap.put(r, new SoftReference<Timeout>(timer.newTimeout((TimerTask)timerTask, this.queueTimeout, TimeUnit.MILLISECONDS)));
    }

    public void cancelQueueTimeoutTask(Runnable r) {
        Optional.ofNullable(this.queueTimeoutMap.remove(r)).map(SoftReference::get).ifPresent(Timeout::cancel);
    }

    public void startRunTimeoutTask(Thread t, Runnable r) {
        if (this.runTimeout <= 0L) {
            return;
        }
        HashedWheelTimer timer = (HashedWheelTimer)ApplicationContextHolder.getBean(HashedWheelTimer.class);
        RunTimeoutTimerTask timerTask = new RunTimeoutTimerTask(this.executorWrapper, r, t);
        this.runTimeoutMap.put(r, new SoftReference<Timeout>(timer.newTimeout((TimerTask)timerTask, this.runTimeout, TimeUnit.MILLISECONDS)));
    }

    public void cancelRunTimeoutTask(Runnable r) {
        Optional.ofNullable(this.runTimeoutMap.remove(r)).map(SoftReference::get).ifPresent(Timeout::cancel);
    }

    public void startTask(Runnable r) {
        this.stopWatchMap.put(r, System.currentTimeMillis());
    }

    public void completeTask(Runnable r) {
        Optional.ofNullable(this.stopWatchMap.remove(r)).ifPresent(millis -> {
            long rt = System.currentTimeMillis() - millis;
            this.performanceProvider.completeTask(rt);
        });
    }

    public PerformanceProvider getPerformanceProvider() {
        return this.performanceProvider;
    }
}

