/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.support.task.runnable;

import java.util.Objects;
import java.util.concurrent.Executor;
import org.dromara.dynamictp.core.aware.AwareManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancedRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(EnhancedRunnable.class);
    private final Runnable runnable;
    private final Executor executor;

    public EnhancedRunnable(Runnable runnable, Executor executor) {
        this.runnable = runnable;
        this.executor = executor;
    }

    public static EnhancedRunnable of(Runnable runnable, Executor executor) {
        return new EnhancedRunnable(runnable, executor);
    }

    @Override
    public void run() {
        if (Objects.isNull(this.runnable)) {
            return;
        }
        AwareManager.beforeExecute(this.executor, Thread.currentThread(), this);
        Exception t = null;
        try {
            this.runnable.run();
        }
        catch (Exception e) {
            t = e;
            throw e;
        }
        finally {
            AwareManager.afterExecute(this.executor, this, t);
        }
    }
}

