/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.support.task.runnable;

import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.MDC;

public class MdcRunnable
implements Runnable {
    private final Runnable runnable;
    private final Thread parentThread;
    private final Map<String, String> parentMdc;

    public MdcRunnable(Runnable runnable) {
        this.runnable = runnable;
        this.parentMdc = MDC.getCopyOfContextMap();
        this.parentThread = Thread.currentThread();
    }

    public static MdcRunnable get(Runnable runnable) {
        return new MdcRunnable(runnable);
    }

    @Override
    public void run() {
        if (MapUtils.isEmpty(this.parentMdc) || Objects.equals(Thread.currentThread(), this.parentThread)) {
            this.runnable.run();
            return;
        }
        for (Map.Entry<String, String> entry : this.parentMdc.entrySet()) {
            MDC.put((String)entry.getKey(), (String)entry.getValue());
        }
        try {
            this.runnable.run();
        }
        finally {
            for (Map.Entry<String, String> entry : this.parentMdc.entrySet()) {
                if ("traceId".equals(entry.getKey())) continue;
                MDC.remove((String)entry.getKey());
            }
        }
    }
}

