/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.support.task.wrapper;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.dynamictp.common.util.ExtensionServiceLoader;
import org.dromara.dynamictp.common.util.StringUtil;
import org.dromara.dynamictp.core.support.task.wrapper.MdcTaskWrapper;
import org.dromara.dynamictp.core.support.task.wrapper.TaskWrapper;
import org.dromara.dynamictp.core.support.task.wrapper.TtlTaskWrapper;

public class TaskWrappers {
    private static final List<TaskWrapper> TASK_WRAPPERS = Lists.newArrayList();

    private TaskWrappers() {
        List loadedWrappers = ExtensionServiceLoader.get(TaskWrapper.class);
        if (CollectionUtils.isNotEmpty((Collection)loadedWrappers)) {
            TASK_WRAPPERS.addAll(loadedWrappers);
        }
        TASK_WRAPPERS.add(new TtlTaskWrapper());
        TASK_WRAPPERS.add(new MdcTaskWrapper());
    }

    public List<TaskWrapper> getByNames(Set<String> names) {
        if (CollectionUtils.isEmpty(names)) {
            return Collections.emptyList();
        }
        return TASK_WRAPPERS.stream().filter(t -> StringUtil.containsIgnoreCase((CharSequence)t.name(), (Collection)names)).collect(Collectors.toList());
    }

    public static TaskWrappers getInstance() {
        return TaskWrappersHolder.INSTANCE;
    }

    private static class TaskWrappersHolder {
        private static final TaskWrappers INSTANCE = new TaskWrappers();

        private TaskWrappersHolder() {
        }
    }
}

