/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.system;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.concurrent.TimeUnit;
import org.dromara.dynamictp.core.system.OperatingSystemBeanManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuMetricsCaptor
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(CpuMetricsCaptor.class);
    private double currProcessCpuUsage = -1.0;
    private long prevProcessCpuTime = 0L;
    private long prevUpTime = 0L;

    public double getProcessCpuUsage() {
        return this.currProcessCpuUsage;
    }

    @Override
    public void run() {
        try {
            OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
            int cpuCores = osBean.getAvailableProcessors();
            long newProcessCpuTime = OperatingSystemBeanManager.getProcessCpuTime();
            RuntimeMXBean runtimeBean = ManagementFactory.getPlatformMXBean(RuntimeMXBean.class);
            long newUpTime = runtimeBean.getUptime();
            long elapsedCpu = TimeUnit.NANOSECONDS.toMillis(newProcessCpuTime - this.prevProcessCpuTime);
            long elapsedTime = newUpTime - this.prevUpTime;
            double processCpuUsage = (double)elapsedCpu / (double)elapsedTime / (double)cpuCores;
            this.prevProcessCpuTime = newProcessCpuTime;
            this.prevUpTime = newUpTime;
            this.currProcessCpuUsage = processCpuUsage;
        }
        catch (Throwable e) {
            log.error("Get system metrics error.", e);
        }
    }
}

