/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.system;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;
import java.util.function.ToLongFunction;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryMetricsCaptor
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(MemoryMetricsCaptor.class);
    private double max = -1.0;
    private double used = -1.0;

    public double getLongLivedMemoryUsage() {
        if (this.max == -1.0 || this.used == -1.0) {
            return -1.0;
        }
        return this.used / this.max;
    }

    @Override
    public void run() {
        try {
            List<MemoryPoolMXBean> memoryPoolBeans = ManagementFactory.getPlatformMXBeans(MemoryPoolMXBean.class);
            if (CollectionUtils.isEmpty(memoryPoolBeans)) {
                return;
            }
            for (MemoryPoolMXBean memoryPoolBean : memoryPoolBeans) {
                String name = memoryPoolBean.getName();
                boolean isLongLivedPool = this.isLongLivedPool(name);
                if (!isLongLivedPool) continue;
                this.used = this.getUsageValue(memoryPoolBean, MemoryUsage::getUsed);
                this.max = this.getUsageValue(memoryPoolBean, MemoryUsage::getMax);
                break;
            }
        }
        catch (Exception e) {
            log.warn("MemoryMetricsCaptor run failed.", (Throwable)e);
        }
    }

    private double getUsageValue(MemoryPoolMXBean memoryPoolMXBean, ToLongFunction<MemoryUsage> getter) {
        MemoryUsage usage = this.getUsage(memoryPoolMXBean);
        if (usage == null) {
            return -1.0;
        }
        return getter.applyAsLong(usage);
    }

    private MemoryUsage getUsage(MemoryPoolMXBean memoryPoolMXBean) {
        try {
            return memoryPoolMXBean.getUsage();
        }
        catch (InternalError e) {
            return null;
        }
    }

    private boolean isLongLivedPool(String name) {
        return StringUtils.isNotBlank((CharSequence)name) && (name.endsWith("Old Gen") || name.endsWith("Tenured Gen") || "ZHeap".equals(name) || "Shenandoah".equals(name) || name.endsWith("balanced-old") || name.contains("tenured") || "JavaHeap".equals(name));
    }
}

