/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.system;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.dromara.dynamictp.common.util.MethodUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatingSystemBeanManager {
    private static final Logger log = LoggerFactory.getLogger(OperatingSystemBeanManager.class);
    private static final List<String> OPERATING_SYSTEM_BEAN_CLASS_NAMES = Arrays.asList("com.sun.management.OperatingSystemMXBean", "com.ibm.lang.management.OperatingSystemMXBean");
    private static final OperatingSystemMXBean OPERATING_SYSTEM_BEAN = ManagementFactory.getOperatingSystemMXBean();
    private static final Class<?> OPERATING_SYSTEM_BEAN_CLASS = OperatingSystemBeanManager.loadOne(OPERATING_SYSTEM_BEAN_CLASS_NAMES);
    private static final Method SYSTEM_CPU_USAGE_METHOD = OperatingSystemBeanManager.deduceMethod("getSystemCpuLoad");
    private static final Method PROCESS_CPU_TIME_METHOD = OperatingSystemBeanManager.deduceMethod("getProcessCpuTime");
    private static final Method FREE_PHYSICAL_MEM_METHOD;
    private static final Method TOTAL_PHYSICAL_MEM_METHOD;

    private OperatingSystemBeanManager() {
    }

    public static OperatingSystemMXBean getOperatingSystemBean() {
        return OPERATING_SYSTEM_BEAN;
    }

    public static double getSystemCpuUsage() {
        return MethodUtil.invokeAndReturnDouble((Method)SYSTEM_CPU_USAGE_METHOD, (Object)OPERATING_SYSTEM_BEAN);
    }

    public static long getProcessCpuTime() {
        return MethodUtil.invokeAndReturnLong((Method)PROCESS_CPU_TIME_METHOD, (Object)OPERATING_SYSTEM_BEAN);
    }

    public static long getTotalPhysicalMem() {
        return MethodUtil.invokeAndReturnLong((Method)TOTAL_PHYSICAL_MEM_METHOD, (Object)OPERATING_SYSTEM_BEAN);
    }

    public static long getFreePhysicalMem() {
        return MethodUtil.invokeAndReturnLong((Method)FREE_PHYSICAL_MEM_METHOD, (Object)OPERATING_SYSTEM_BEAN);
    }

    private static Class<?> loadOne(List<String> classNames) {
        for (String className : classNames) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                log.warn("Failed to load operating system bean class.", (Throwable)e);
            }
        }
        return null;
    }

    private static Method deduceMethod(String name) {
        if (Objects.isNull(OPERATING_SYSTEM_BEAN_CLASS)) {
            return null;
        }
        try {
            OPERATING_SYSTEM_BEAN_CLASS.cast(OPERATING_SYSTEM_BEAN);
            return OPERATING_SYSTEM_BEAN_CLASS.getDeclaredMethod(name, new Class[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        Method totalPhysicalMem = OperatingSystemBeanManager.deduceMethod("getTotalPhysicalMemorySize");
        TOTAL_PHYSICAL_MEM_METHOD = totalPhysicalMem != null ? totalPhysicalMem : OperatingSystemBeanManager.deduceMethod("getTotalPhysicalMemory");
        FREE_PHYSICAL_MEM_METHOD = OperatingSystemBeanManager.deduceMethod("getFreePhysicalMemorySize");
    }
}

