/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.system;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.dromara.dynamictp.core.support.ThreadPoolCreator;
import org.dromara.dynamictp.core.system.CpuMetricsCaptor;
import org.dromara.dynamictp.core.system.MemoryMetricsCaptor;
import org.dromara.dynamictp.core.system.OperatingSystemBeanManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemMetricManager {
    private static final Logger log = LoggerFactory.getLogger(SystemMetricManager.class);
    private static final CpuMetricsCaptor CPU_METRICS_CAPTOR;
    private static final MemoryMetricsCaptor MEMORY_METRICS_CAPTOR;
    private static final ScheduledExecutorService EXECUTOR;

    public static String getSystemMetric() {
        OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        double systemAvgLoad = osBean.getSystemLoadAverage();
        double systemCpuUsage = OperatingSystemBeanManager.getSystemCpuUsage();
        int cpuCores = osBean.getAvailableProcessors();
        return String.format("SystemMetric{sAvgLoad=%.2f, sCpuUsage=%.2f, pCpuUsage=%.2f, cpuCores=%d, oldMemUsage=%.2f}", systemAvgLoad, systemCpuUsage, SystemMetricManager.getProcessCpuUsage(), cpuCores, SystemMetricManager.getLongLivedMemoryUsage());
    }

    public static double getProcessCpuUsage() {
        return CPU_METRICS_CAPTOR.getProcessCpuUsage();
    }

    public static double getLongLivedMemoryUsage() {
        return MEMORY_METRICS_CAPTOR.getLongLivedMemoryUsage();
    }

    public static void stop() {
        EXECUTOR.shutdown();
    }

    static {
        EXECUTOR = ThreadPoolCreator.newScheduledThreadPool("dtp-system-metric", 1);
        CPU_METRICS_CAPTOR = new CpuMetricsCaptor();
        MEMORY_METRICS_CAPTOR = new MemoryMetricsCaptor();
        EXECUTOR.scheduleAtFixedRate(CPU_METRICS_CAPTOR, 0L, 2L, TimeUnit.SECONDS);
        EXECUTOR.scheduleAtFixedRate(MEMORY_METRICS_CAPTOR, 0L, 2L, TimeUnit.SECONDS);
    }
}

