/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.timer;

import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.dromara.dynamictp.common.timer.Timeout;
import org.dromara.dynamictp.common.timer.TimerTask;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.dromara.dynamictp.core.support.ThreadPoolStatProvider;
import org.dromara.dynamictp.core.support.task.runnable.DtpRunnable;

public abstract class AbstractTimeoutTimerTask
implements TimerTask {
    protected final ExecutorWrapper executorWrapper;
    protected final Runnable runnable;

    protected AbstractTimeoutTimerTask(ExecutorWrapper executorWrapper, Runnable runnable) {
        this.executorWrapper = executorWrapper;
        this.runnable = runnable;
    }

    public void run(Timeout timeout) throws Exception {
        ThreadPoolStatProvider statProvider = this.executorWrapper.getThreadPoolStatProvider();
        if (Objects.isNull(statProvider)) {
            return;
        }
        this.doRun();
    }

    protected Pair<String, String> getTaskNameAndTraceId() {
        String taskName = "";
        String traceId = "";
        if (this.runnable instanceof DtpRunnable) {
            DtpRunnable dtpRunnable = (DtpRunnable)this.runnable;
            taskName = dtpRunnable.getTaskName();
            traceId = dtpRunnable.getTraceId();
        }
        return Pair.of((Object)taskName, (Object)traceId);
    }

    protected abstract void doRun();
}

