/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.timer;

import cn.hutool.core.text.CharSequenceUtil;
import org.apache.commons.lang3.tuple.Pair;
import org.dromara.dynamictp.common.em.NotifyItemEnum;
import org.dromara.dynamictp.core.notifier.manager.AlarmManager;
import org.dromara.dynamictp.core.support.ExecutorAdapter;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.dromara.dynamictp.core.support.ThreadPoolStatProvider;
import org.dromara.dynamictp.core.timer.AbstractTimeoutTimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueTimeoutTimerTask
extends AbstractTimeoutTimerTask {
    private static final Logger log = LoggerFactory.getLogger(QueueTimeoutTimerTask.class);

    public QueueTimeoutTimerTask(ExecutorWrapper executorWrapper, Runnable runnable) {
        super(executorWrapper, runnable);
    }

    @Override
    protected void doRun() {
        ThreadPoolStatProvider statProvider = this.executorWrapper.getThreadPoolStatProvider();
        ExecutorAdapter<?> executor = statProvider.getExecutorWrapper().getExecutor();
        Pair<String, String> pair = this.getTaskNameAndTraceId();
        statProvider.incQueueTimeoutCount(1);
        AlarmManager.tryAlarmAsync(this.executorWrapper, NotifyItemEnum.QUEUE_TIMEOUT, this.runnable);
        String logMsg = CharSequenceUtil.format((CharSequence)"DynamicTp execute, queue timeout, tpName: {}, taskName: {}, traceId: {}, queueTimeout: {}ms, poolSize: {} (active: {}, core: {}, max: {}, largest: {}), queueCapacity: {} (currSize: {}, remaining: {})", (Object[])new Object[]{statProvider.getExecutorWrapper().getThreadPoolName(), pair.getLeft(), pair.getRight(), statProvider.getQueueTimeout(), executor.getPoolSize(), executor.getActiveCount(), executor.getCorePoolSize(), executor.getMaximumPoolSize(), executor.getLargestPoolSize(), statProvider.getExecutorWrapper().getExecutor().getQueueCapacity(), executor.getQueue().size(), executor.getQueue().remainingCapacity()});
        log.warn(logMsg);
    }
}

