/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.timer;

import cn.hutool.core.text.CharSequenceUtil;
import org.apache.commons.lang3.tuple.Pair;
import org.dromara.dynamictp.common.em.NotifyItemEnum;
import org.dromara.dynamictp.core.notifier.manager.AlarmManager;
import org.dromara.dynamictp.core.support.ExecutorAdapter;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.dromara.dynamictp.core.support.ThreadPoolStatProvider;
import org.dromara.dynamictp.core.timer.AbstractTimeoutTimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunTimeoutTimerTask
extends AbstractTimeoutTimerTask {
    private static final Logger log = LoggerFactory.getLogger(RunTimeoutTimerTask.class);
    private final Thread thread;

    public RunTimeoutTimerTask(ExecutorWrapper executorWrapper, Runnable runnable, Thread thread) {
        super(executorWrapper, runnable);
        this.thread = thread;
    }

    @Override
    protected void doRun() {
        ThreadPoolStatProvider statProvider = this.executorWrapper.getThreadPoolStatProvider();
        ExecutorAdapter<?> executor = statProvider.getExecutorWrapper().getExecutor();
        Pair<String, String> pair = this.getTaskNameAndTraceId();
        statProvider.incRunTimeoutCount(1);
        AlarmManager.tryAlarmAsync(this.executorWrapper, NotifyItemEnum.RUN_TIMEOUT, this.runnable);
        String logMsg = CharSequenceUtil.format((CharSequence)"DynamicTp execute, run timeout, tpName: {}, taskName: {}, traceId: {}, runTimeout: {}ms, poolSize: {} (active: {}, core: {}, max: {}, largest: {}), queueCapacity: {} (currSize: {}, remaining: {}), stackTrace: {}", (Object[])new Object[]{statProvider.getExecutorWrapper().getThreadPoolName(), pair.getLeft(), pair.getRight(), statProvider.getRunTimeout(), executor.getPoolSize(), executor.getActiveCount(), executor.getCorePoolSize(), executor.getMaximumPoolSize(), executor.getLargestPoolSize(), statProvider.getExecutorWrapper().getExecutor().getQueueCapacity(), executor.getQueue().size(), executor.getQueue().remainingCapacity(), this.traceToString(this.thread.getStackTrace())});
        log.warn(logMsg);
        if (statProvider.isTryInterrupt()) {
            this.thread.interrupt();
        }
    }

    public String traceToString(StackTraceElement[] trace) {
        StringBuilder builder = new StringBuilder(512);
        builder.append("\n");
        for (StackTraceElement traceElement : trace) {
            builder.append("\tat ").append(traceElement).append("\n");
        }
        return builder.toString();
    }
}

