/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.codec.hash;

import java.util.Arrays;
import org.dromara.hutool.core.codec.Number128;
import org.dromara.hutool.core.codec.hash.Hash128;
import org.dromara.hutool.core.codec.hash.Hash32;
import org.dromara.hutool.core.codec.hash.Hash64;
import org.dromara.hutool.core.util.ByteUtil;

public class CityHash
implements Hash32<byte[]>,
Hash64<byte[]>,
Hash128<byte[]> {
    public static CityHash INSTANCE = new CityHash();
    private static final long k0 = -4348849565147123417L;
    private static final long k1 = -5435081209227447693L;
    private static final long k2 = -7286425919675154353L;
    private static final int c1 = -862048943;
    private static final int c2 = 461845907;

    @Override
    public Number encode(byte[] bytes) {
        return this.hash64(bytes);
    }

    @Override
    public int hash32(byte[] data) {
        int g;
        int len = data.length;
        if (len <= 24) {
            return len <= 12 ? (len <= 4 ? this.hash32Len0to4(data) : this.hash32Len5to12(data)) : this.hash32Len13to24(data);
        }
        int h = len;
        int f = g = -862048943 * len;
        int a0 = Integer.rotateRight(CityHash.fetch32(data, len - 4) * -862048943, 17) * 461845907;
        int a1 = Integer.rotateRight(CityHash.fetch32(data, len - 8) * -862048943, 17) * 461845907;
        int a2 = Integer.rotateRight(CityHash.fetch32(data, len - 16) * -862048943, 17) * 461845907;
        int a3 = Integer.rotateRight(CityHash.fetch32(data, len - 12) * -862048943, 17) * 461845907;
        int a4 = Integer.rotateRight(CityHash.fetch32(data, len - 20) * -862048943, 17) * 461845907;
        h ^= a0;
        h = Integer.rotateRight(h, 19);
        h = h * 5 + -430675100;
        h ^= a2;
        h = Integer.rotateRight(h, 19);
        h = h * 5 + -430675100;
        g ^= a1;
        g = Integer.rotateRight(g, 19);
        g = g * 5 + -430675100;
        g ^= a3;
        g = Integer.rotateRight(g, 19);
        g = g * 5 + -430675100;
        f += a4;
        f = Integer.rotateRight(f, 19);
        f = f * 5 + -430675100;
        int iters = (len - 1) / 20;
        int pos = 0;
        do {
            a0 = Integer.rotateRight(CityHash.fetch32(data, pos) * -862048943, 17) * 461845907;
            a1 = CityHash.fetch32(data, pos + 4);
            a2 = Integer.rotateRight(CityHash.fetch32(data, pos + 8) * -862048943, 17) * 461845907;
            a3 = Integer.rotateRight(CityHash.fetch32(data, pos + 12) * -862048943, 17) * 461845907;
            a4 = CityHash.fetch32(data, pos + 16);
            h ^= a0;
            h = Integer.rotateRight(h, 18);
            h = h * 5 + -430675100;
            f += a1;
            f = Integer.rotateRight(f, 19);
            f *= -862048943;
            g += a2;
            g = Integer.rotateRight(g, 18);
            g = g * 5 + -430675100;
            h ^= a3 + a1;
            h = Integer.rotateRight(h, 19);
            h = h * 5 + -430675100;
            g ^= a4;
            g = Integer.reverseBytes(g) * 5;
            h += a4 * 5;
            h = Integer.reverseBytes(h);
            int swapValue = f += a0;
            f = g;
            g = h;
            h = swapValue;
            pos += 20;
        } while (--iters != 0);
        g = Integer.rotateRight(g, 11) * -862048943;
        g = Integer.rotateRight(g, 17) * -862048943;
        f = Integer.rotateRight(f, 11) * -862048943;
        f = Integer.rotateRight(f, 17) * -862048943;
        h = Integer.rotateRight(h + g, 19);
        h = h * 5 + -430675100;
        h = Integer.rotateRight(h, 17) * -862048943;
        h = Integer.rotateRight(h + f, 19);
        h = h * 5 + -430675100;
        h = Integer.rotateRight(h, 17) * -862048943;
        return h;
    }

    @Override
    public long hash64(byte[] data) {
        int len = data.length;
        if (len <= 32) {
            if (len <= 16) {
                return this.hashLen0to16(data);
            }
            return this.hashLen17to32(data);
        }
        if (len <= 64) {
            return this.hashLen33to64(data);
        }
        long x = CityHash.fetch64(data, len - 40);
        long y = CityHash.fetch64(data, len - 16) + CityHash.fetch64(data, len - 56);
        long z = this.hashLen16(CityHash.fetch64(data, len - 48) + (long)len, CityHash.fetch64(data, len - 24));
        Number128 v = CityHash.weakHashLen32WithSeeds(data, len - 64, len, z);
        Number128 w = CityHash.weakHashLen32WithSeeds(data, len - 32, y + -5435081209227447693L, x);
        x = x * -5435081209227447693L + CityHash.fetch64(data, 0);
        len = len - 1 & 0xFFFFFFC0;
        int pos = 0;
        do {
            x = Long.rotateRight(x + y + v.getLeastSigBits() + CityHash.fetch64(data, pos + 8), 37) * -5435081209227447693L;
            y = Long.rotateRight(y + v.getMostSigBits() + CityHash.fetch64(data, pos + 48), 42) * -5435081209227447693L;
            z = Long.rotateRight(z + w.getLeastSigBits(), 33) * -5435081209227447693L;
            v = CityHash.weakHashLen32WithSeeds(data, pos, v.getMostSigBits() * -5435081209227447693L, (x ^= w.getMostSigBits()) + w.getLeastSigBits());
            w = CityHash.weakHashLen32WithSeeds(data, pos + 32, z + w.getMostSigBits(), (y += v.getLeastSigBits() + CityHash.fetch64(data, pos + 40)) + CityHash.fetch64(data, pos + 16));
            long swapValue = x;
            x = z;
            z = swapValue;
            pos += 64;
        } while ((len -= 64) != 0);
        return this.hashLen16(this.hashLen16(v.getLeastSigBits(), w.getLeastSigBits()) + CityHash.shiftMix(y) * -5435081209227447693L + z, this.hashLen16(v.getMostSigBits(), w.getMostSigBits()) + x);
    }

    public long hash64(byte[] data, long seed0, long seed1) {
        return this.hashLen16(this.hash64(data) - seed0, seed1);
    }

    public long hash64(byte[] data, long seed) {
        return this.hash64(data, -7286425919675154353L, seed);
    }

    @Override
    public Number128 hash128(byte[] data) {
        int len = data.length;
        return len >= 16 ? this.hash128(data, 16, new Number128(CityHash.fetch64(data, 8) + -4348849565147123417L, CityHash.fetch64(data, 0))) : this.hash128(data, 0, new Number128(-5435081209227447693L, -4348849565147123417L));
    }

    public Number128 hash128(byte[] data, Number128 seed) {
        return this.hash128(data, 0, seed);
    }

    private Number128 hash128(byte[] byteArray, int start, Number128 seed) {
        int len = byteArray.length - start;
        if (len < 128) {
            return this.cityMurmur(Arrays.copyOfRange(byteArray, start, byteArray.length), seed);
        }
        Number128 v = new Number128(0L, 0L);
        Number128 w = new Number128(0L, 0L);
        long x = seed.getLeastSigBits();
        long y = seed.getMostSigBits();
        long z = (long)len * -5435081209227447693L;
        v.setLeastSigBits(Long.rotateRight(y ^ 0xB492B66FBE98F273L, 49) * -5435081209227447693L + CityHash.fetch64(byteArray, start));
        v.setMostSigBits(Long.rotateRight(v.getLeastSigBits(), 42) * -5435081209227447693L + CityHash.fetch64(byteArray, start + 8));
        w.setLeastSigBits(Long.rotateRight(y + z, 35) * -5435081209227447693L + x);
        w.setMostSigBits(Long.rotateRight(x + CityHash.fetch64(byteArray, start + 88), 53) * -5435081209227447693L);
        int pos = start;
        do {
            x = Long.rotateRight(x + y + v.getLeastSigBits() + CityHash.fetch64(byteArray, pos + 8), 37) * -5435081209227447693L;
            y = Long.rotateRight(y + v.getMostSigBits() + CityHash.fetch64(byteArray, pos + 48), 42) * -5435081209227447693L;
            y += v.getLeastSigBits() + CityHash.fetch64(byteArray, pos + 40);
            z = Long.rotateRight(z + w.getLeastSigBits(), 33) * -5435081209227447693L;
            v = CityHash.weakHashLen32WithSeeds(byteArray, pos, v.getMostSigBits() * -5435081209227447693L, (x ^= w.getMostSigBits()) + w.getLeastSigBits());
            w = CityHash.weakHashLen32WithSeeds(byteArray, pos + 32, z + w.getMostSigBits(), y + CityHash.fetch64(byteArray, pos + 16));
            long swapValue = x;
            x = z;
            z = swapValue;
            x = Long.rotateRight(x + y + v.getLeastSigBits() + CityHash.fetch64(byteArray, (pos += 64) + 8), 37) * -5435081209227447693L;
            y = Long.rotateRight(y + v.getMostSigBits() + CityHash.fetch64(byteArray, pos + 48), 42) * -5435081209227447693L;
            y += v.getLeastSigBits() + CityHash.fetch64(byteArray, pos + 40);
            z = Long.rotateRight(z + w.getLeastSigBits(), 33) * -5435081209227447693L;
            v = CityHash.weakHashLen32WithSeeds(byteArray, pos, v.getMostSigBits() * -5435081209227447693L, (x ^= w.getMostSigBits()) + w.getLeastSigBits());
            w = CityHash.weakHashLen32WithSeeds(byteArray, pos + 32, z + w.getMostSigBits(), y + CityHash.fetch64(byteArray, pos + 16));
            swapValue = x;
            x = z;
            z = swapValue;
            pos += 64;
        } while ((len -= 128) >= 128);
        x += Long.rotateRight(v.getLeastSigBits() + z, 49) * -4348849565147123417L;
        y = y * -4348849565147123417L + Long.rotateRight(w.getMostSigBits(), 37);
        z = z * -4348849565147123417L + Long.rotateRight(w.getLeastSigBits(), 27);
        w.setLeastSigBits(w.getLeastSigBits() * 9L);
        v.setLeastSigBits(v.getLeastSigBits() * -4348849565147123417L);
        int tail_done = 0;
        while (tail_done < len) {
            y = Long.rotateRight(x + y, 42) * -4348849565147123417L + v.getMostSigBits();
            w.setLeastSigBits(w.getLeastSigBits() + CityHash.fetch64(byteArray, pos + len - (tail_done += 32) + 16));
            x = x * -4348849565147123417L + w.getLeastSigBits();
            w.setMostSigBits(w.getMostSigBits() + v.getLeastSigBits());
            v = CityHash.weakHashLen32WithSeeds(byteArray, pos + len - tail_done, v.getLeastSigBits() + (z += w.getMostSigBits() + CityHash.fetch64(byteArray, pos + len - tail_done)), v.getMostSigBits());
            v.setLeastSigBits(v.getLeastSigBits() * -4348849565147123417L);
        }
        x = this.hashLen16(x, v.getLeastSigBits());
        y = this.hashLen16(y + z, w.getLeastSigBits());
        return new Number128(this.hashLen16(x + w.getMostSigBits(), y + v.getMostSigBits()), this.hashLen16(x + v.getMostSigBits(), w.getMostSigBits()) + y);
    }

    private int hash32Len0to4(byte[] byteArray) {
        int b = 0;
        int c = 9;
        int len = byteArray.length;
        for (byte v : byteArray) {
            b = b * -862048943 + v;
            c ^= b;
        }
        return CityHash.fmix(this.mur(b, this.mur(len, c)));
    }

    private int hash32Len5to12(byte[] byteArray) {
        int len;
        int a = len = byteArray.length;
        int b = len * 5;
        int c = 9;
        int d = b;
        return CityHash.fmix(this.mur(c += CityHash.fetch32(byteArray, len >>> 1 & 4), this.mur(b += CityHash.fetch32(byteArray, len - 4), this.mur(a += CityHash.fetch32(byteArray, 0), d))));
    }

    private int hash32Len13to24(byte[] byteArray) {
        int len = byteArray.length;
        int a = CityHash.fetch32(byteArray, (len >>> 1) - 4);
        int b = CityHash.fetch32(byteArray, 4);
        int c = CityHash.fetch32(byteArray, len - 8);
        int d = CityHash.fetch32(byteArray, len >>> 1);
        int e = CityHash.fetch32(byteArray, 0);
        int f = CityHash.fetch32(byteArray, len - 4);
        int h = len;
        return CityHash.fmix(this.mur(f, this.mur(e, this.mur(d, this.mur(c, this.mur(b, this.mur(a, h)))))));
    }

    private long hashLen0to16(byte[] byteArray) {
        int len = byteArray.length;
        if (len >= 8) {
            long mul = -7286425919675154353L + (long)len * 2L;
            long a = CityHash.fetch64(byteArray, 0) + -7286425919675154353L;
            long b = CityHash.fetch64(byteArray, len - 8);
            long c = Long.rotateRight(b, 37) * mul + a;
            long d = (Long.rotateRight(a, 25) + b) * mul;
            return CityHash.hashLen16(c, d, mul);
        }
        if (len >= 4) {
            long mul = -7286425919675154353L + (long)(len * 2);
            long a = (long)CityHash.fetch32(byteArray, 0) & 0xFFFFFFFFL;
            return CityHash.hashLen16((long)len + (a << 3), (long)CityHash.fetch32(byteArray, len - 4) & 0xFFFFFFFFL, mul);
        }
        if (len > 0) {
            int a = byteArray[0] & 0xFF;
            int b = byteArray[len >>> 1] & 0xFF;
            int c = byteArray[len - 1] & 0xFF;
            int y = a + (b << 8);
            int z = len + (c << 2);
            return CityHash.shiftMix((long)y * -7286425919675154353L ^ (long)z * -4348849565147123417L) * -7286425919675154353L;
        }
        return -7286425919675154353L;
    }

    private long hashLen17to32(byte[] byteArray) {
        int len = byteArray.length;
        long mul = -7286425919675154353L + (long)len * 2L;
        long a = CityHash.fetch64(byteArray, 0) * -5435081209227447693L;
        long b = CityHash.fetch64(byteArray, 8);
        long c = CityHash.fetch64(byteArray, len - 8) * mul;
        long d = CityHash.fetch64(byteArray, len - 16) * -7286425919675154353L;
        return CityHash.hashLen16(Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
    }

    private long hashLen33to64(byte[] byteArray) {
        int len = byteArray.length;
        long mul = -7286425919675154353L + (long)len * 2L;
        long a = CityHash.fetch64(byteArray, 0) * -7286425919675154353L;
        long b = CityHash.fetch64(byteArray, 8);
        long c = CityHash.fetch64(byteArray, len - 24);
        long d = CityHash.fetch64(byteArray, len - 32);
        long e = CityHash.fetch64(byteArray, 16) * -7286425919675154353L;
        long f = CityHash.fetch64(byteArray, 24) * 9L;
        long g = CityHash.fetch64(byteArray, len - 8);
        long h = CityHash.fetch64(byteArray, len - 16) * mul;
        long u = Long.rotateRight(a + g, 43) + (Long.rotateRight(b, 30) + c) * 9L;
        long v = (a + g ^ d) + f + 1L;
        long w = Long.reverseBytes((u + v) * mul) + h;
        long x = Long.rotateRight(e + f, 42) + c;
        long y = (Long.reverseBytes((v + w) * mul) + g) * mul;
        long z = e + f + c;
        a = Long.reverseBytes((x + z) * mul + y) + b;
        b = CityHash.shiftMix((z + a) * mul + d + h) * mul;
        return b + x;
    }

    private static long fetch64(byte[] byteArray, int start) {
        return ByteUtil.toLong(byteArray, start, ByteUtil.CPU_ENDIAN);
    }

    private static int fetch32(byte[] byteArray, int start) {
        return ByteUtil.toInt(byteArray, start, ByteUtil.CPU_ENDIAN);
    }

    private static long hashLen16(long u, long v, long mul) {
        long a = (u ^ v) * mul;
        a ^= a >>> 47;
        long b = (v ^ a) * mul;
        b ^= b >>> 47;
        return b *= mul;
    }

    private long hashLen16(long u, long v) {
        return this.hash128to64(new Number128(v, u));
    }

    private long hash128to64(Number128 number128) {
        long kMul = -7070675565921424023L;
        long a = (number128.getLeastSigBits() ^ number128.getMostSigBits()) * -7070675565921424023L;
        a ^= a >>> 47;
        long b = (number128.getMostSigBits() ^ a) * -7070675565921424023L;
        b ^= b >>> 47;
        return b *= -7070675565921424023L;
    }

    private static long shiftMix(long val) {
        return val ^ val >>> 47;
    }

    private static int fmix(int h) {
        h ^= h >>> 16;
        h *= -2048144789;
        h ^= h >>> 13;
        h *= -1028477387;
        h ^= h >>> 16;
        return h;
    }

    private int mur(int a, int h) {
        a *= -862048943;
        a = Integer.rotateRight(a, 17);
        h ^= (a *= 461845907);
        h = Integer.rotateRight(h, 19);
        return h * 5 + -430675100;
    }

    private static Number128 weakHashLen32WithSeeds(long w, long x, long y, long z, long a, long b) {
        b = Long.rotateRight(b + (a += w) + z, 21);
        long c = a;
        a += x;
        return new Number128((b += Long.rotateRight(a += y, 44)) + c, a + z);
    }

    private static Number128 weakHashLen32WithSeeds(byte[] byteArray, int start, long a, long b) {
        return CityHash.weakHashLen32WithSeeds(CityHash.fetch64(byteArray, start), CityHash.fetch64(byteArray, start + 8), CityHash.fetch64(byteArray, start + 16), CityHash.fetch64(byteArray, start + 24), a, b);
    }

    private Number128 cityMurmur(byte[] byteArray, Number128 seed) {
        long d;
        long c;
        int len = byteArray.length;
        long a = seed.getLeastSigBits();
        long b = seed.getMostSigBits();
        int l = len - 16;
        if (l <= 0) {
            a = CityHash.shiftMix(a * -5435081209227447693L) * -5435081209227447693L;
            c = b * -5435081209227447693L + this.hashLen0to16(byteArray);
            d = CityHash.shiftMix(a + (len >= 8 ? CityHash.fetch64(byteArray, 0) : c));
        } else {
            c = this.hashLen16(CityHash.fetch64(byteArray, len - 8) + -5435081209227447693L, a);
            d = this.hashLen16(b + (long)len, c + CityHash.fetch64(byteArray, len - 16));
            a += d;
            int pos = 0;
            do {
                a ^= CityHash.shiftMix(CityHash.fetch64(byteArray, pos) * -5435081209227447693L) * -5435081209227447693L;
                b ^= (a *= -5435081209227447693L);
                c ^= CityHash.shiftMix(CityHash.fetch64(byteArray, pos + 8) * -5435081209227447693L) * -5435081209227447693L;
                d ^= (c *= -5435081209227447693L);
                pos += 16;
            } while ((l -= 16) > 0);
        }
        a = this.hashLen16(a, c);
        b = this.hashLen16(d, b);
        return new Number128(this.hashLen16(b, a), a ^ b);
    }
}

