/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import org.dromara.hutool.core.exception.HutoolException;

public class MacAddressUtil {
    public static String getMacAddress(InetAddress inetAddress) {
        return MacAddressUtil.getMacAddress(inetAddress, "-");
    }

    public static String getMacAddress(InetAddress inetAddress, String separator) {
        if (null == inetAddress) {
            return null;
        }
        return MacAddressUtil.toMacAddressStr(MacAddressUtil.getHardwareAddress(inetAddress), separator);
    }

    public static byte[] getHardwareAddress(InetAddress inetAddress) {
        if (null == inetAddress) {
            return null;
        }
        try {
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
            if (null != networkInterface) {
                return networkInterface.getHardwareAddress();
            }
        }
        catch (SocketException e) {
            throw new HutoolException(e);
        }
        return null;
    }

    public static String toMacAddressStr(byte[] mac, String separator) {
        if (null == mac) {
            return null;
        }
        StringBuilder sb = new StringBuilder(mac.length * 2 + (mac.length - 1) * separator.length());
        for (int i = 0; i < mac.length; ++i) {
            String s;
            if (i != 0) {
                sb.append(separator);
            }
            sb.append((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? 0 + s : s);
        }
        return sb.toString();
    }
}

