/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dromara.hutool.core.cache.SimpleCache;
import org.dromara.hutool.core.classloader.ClassLoaderUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.resource.MultiResource;
import org.dromara.hutool.core.io.resource.Resource;
import org.dromara.hutool.core.io.resource.ResourceUtil;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.spi.AbsServiceLoader;
import org.dromara.hutool.core.spi.SpiException;
import org.dromara.hutool.core.text.StrUtil;

public class ListServiceLoader<S>
extends AbsServiceLoader<S> {
    private static final String PREFIX_SERVICES = "META-INF/services/";
    private final List<String> serviceNames = new ArrayList<String>();
    private final SimpleCache<String, S> serviceCache = new SimpleCache(new HashMap());

    public static <S> ListServiceLoader<S> of(Class<S> serviceClass) {
        return ListServiceLoader.of(serviceClass, null);
    }

    public static <S> ListServiceLoader<S> of(Class<S> serviceClass, ClassLoader classLoader) {
        return ListServiceLoader.of(PREFIX_SERVICES, serviceClass, classLoader);
    }

    public static <S> ListServiceLoader<S> of(String pathPrefix, Class<S> serviceClass, ClassLoader classLoader) {
        return new ListServiceLoader<S>(pathPrefix, serviceClass, classLoader, null);
    }

    public ListServiceLoader(String pathPrefix, Class<S> serviceClass, ClassLoader classLoader, Charset charset) {
        super(pathPrefix, serviceClass, classLoader, charset);
        this.load();
    }

    @Override
    public void load() {
        MultiResource resources = ResourceUtil.getResources(this.pathPrefix + this.serviceClass.getName(), this.classLoader);
        for (Resource resource : resources) {
            this.parse(resource);
        }
    }

    @Override
    public int size() {
        return this.serviceNames.size();
    }

    @Override
    public List<String> getServiceNames() {
        return ListUtil.view(this.serviceNames);
    }

    public Class<S> getServiceClass(int index) {
        String serviceClassName = this.serviceNames.get(index);
        if (StrUtil.isBlank(serviceClassName)) {
            return null;
        }
        return this.getServiceClass(serviceClassName);
    }

    @Override
    public Class<S> getServiceClass(String serviceName) {
        return ClassLoaderUtil.loadClass(serviceName);
    }

    public S getService(int index) {
        String serviceClassName = this.serviceNames.get(index);
        if (null == serviceClassName) {
            return null;
        }
        return this.getService(serviceClassName);
    }

    @Override
    public S getService(String serviceName) {
        return (S)this.serviceCache.get(serviceName, () -> this.createService(serviceName));
    }

    @Override
    public Iterator<S> iterator() {
        return new Iterator<S>(){
            private final Iterator<String> nameIter;
            {
                this.nameIter = ListServiceLoader.this.serviceNames.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.nameIter.hasNext();
            }

            @Override
            public S next() {
                return ListServiceLoader.this.getService(this.nameIter.next());
            }
        };
    }

    private void parse(Resource resource) {
        try (BufferedReader reader = resource.getReader(this.charset);){
            int lc = 1;
            while (lc >= 0) {
                lc = this.parseLine(resource, reader, lc);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private int parseLine(Resource resource, BufferedReader reader, int lineNo) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            return -1;
        }
        int ci = line.indexOf(35);
        if (ci >= 0) {
            line = line.substring(0, ci);
        }
        if (!(line = StrUtil.trim(line)).isEmpty()) {
            this.checkLine(resource, lineNo, line);
            List<String> names = this.serviceNames;
            if (!this.serviceCache.containsKey(line) && !names.contains(line)) {
                names.add(line);
            }
        }
        return lineNo + 1;
    }

    private void checkLine(Resource resource, int lineNo, String line) {
        int cp;
        if (StrUtil.containsBlank(line)) {
            this.fail(resource, lineNo, "Illegal configuration-file syntax");
        }
        if (!Character.isJavaIdentifierStart(cp = line.codePointAt(0))) {
            this.fail(resource, lineNo, "Illegal provider-class name: " + line);
        }
        int n = line.length();
        for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
            cp = line.codePointAt(i);
            if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
            this.fail(resource, lineNo, "Illegal provider-class name: " + line);
        }
    }

    private void fail(Resource resource, int lineNo, String msg) {
        throw new SpiException(this.serviceClass + ":" + resource.getUrl() + ":" + lineNo + ": " + msg);
    }

    private S createService(String serviceClassName) {
        return (S)ConstructorUtil.newInstance(ClassLoaderUtil.loadClass(serviceClassName), new Object[0]);
    }
}

