/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.text.replacer;

import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.replacer.StrReplacer;

public class RangeReplacerByChar
extends StrReplacer {
    private static final long serialVersionUID = 1L;
    private final int beginInclude;
    private final int endExclude;
    private final char replacedChar;
    private final boolean isCodePoint;

    public RangeReplacerByChar(int beginInclude, int endExclude, char replacedChar, boolean isCodePoint) {
        this.beginInclude = beginInclude;
        this.endExclude = endExclude;
        this.replacedChar = replacedChar;
        this.isCodePoint = isCodePoint;
    }

    @Override
    public String apply(CharSequence str) {
        if (StrUtil.isEmpty(str)) {
            return StrUtil.toStringOrNull(str);
        }
        int beginInclude = this.beginInclude;
        String originalStr = str.toString();
        int[] chars = StrUtil.toChars(originalStr, this.isCodePoint);
        int strLength = chars.length;
        if (beginInclude > strLength) {
            return originalStr;
        }
        int endExclude = this.endExclude;
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (beginInclude > endExclude) {
            return originalStr;
        }
        StringBuilder stringBuilder = new StringBuilder(originalStr.length());
        for (int i = 0; i < strLength; ++i) {
            if (i >= beginInclude && i < endExclude) {
                this.replace(originalStr, i, stringBuilder);
                continue;
            }
            this.append(stringBuilder, chars[i]);
        }
        return stringBuilder.toString();
    }

    @Override
    protected int replace(CharSequence str, int pos, StringBuilder out) {
        out.appendCodePoint(this.replacedChar);
        return pos;
    }

    private void append(StringBuilder stringBuilder, int c) {
        if (this.isCodePoint) {
            stringBuilder.appendCodePoint(c);
        } else {
            stringBuilder.append((char)c);
        }
    }
}

