/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.log.engine.console;

import java.util.Map;
import org.dromara.hutool.core.date.DateUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.Console;
import org.dromara.hutool.core.map.Dict;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.log.AbstractLog;
import org.dromara.hutool.log.level.Level;

public class ConsoleLog
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private static final String logFormat = "[{date}] [{level}] {name}: {msg}";
    private static Level currentLevel = Level.DEBUG;
    private final String name;

    public ConsoleLog(Class<?> clazz) {
        this.name = null == clazz ? "null" : clazz.getName();
    }

    public ConsoleLog(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static void setLevel(Level customLevel) {
        Assert.notNull((Object)((Object)customLevel));
        currentLevel = customLevel;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    @Override
    public void trace(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, Level.TRACE, t, format, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    @Override
    public void debug(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, Level.DEBUG, t, format, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO);
    }

    @Override
    public void info(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, Level.INFO, t, format, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN);
    }

    @Override
    public void warn(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, Level.WARN, t, format, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR);
    }

    @Override
    public void error(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, Level.ERROR, t, format, arguments);
    }

    @Override
    public void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
        if (!this.isEnabled(level)) {
            return;
        }
        Dict dict = Dict.of().set("date", (Object)DateUtil.formatNow()).set("level", (Object)level.toString()).set("name", (Object)this.name).set("msg", (Object)StrUtil.format((CharSequence)format, (Object[])arguments));
        String logMsg = StrUtil.format((CharSequence)logFormat, (Map)dict);
        if (level.ordinal() >= Level.WARN.ordinal()) {
            Console.error((Throwable)t, (String)logMsg, (Object[])new Object[0]);
        } else {
            Console.log((Throwable)t, (String)logMsg, (Object[])new Object[0]);
        }
    }

    @Override
    public boolean isEnabled(Level level) {
        return currentLevel.compareTo(level) <= 0;
    }
}

