/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.core.factory;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.dromara.sms4j.api.SmsBlend;
import org.dromara.sms4j.api.smsProxy.SmsInvocationHandler;
import org.dromara.sms4j.api.universal.SupplierConfig;
import org.dromara.sms4j.comm.config.SmsConfig;
import org.dromara.sms4j.comm.factory.BeanFactory;
import org.dromara.sms4j.core.SupplierSqlConfig;
import org.dromara.sms4j.provider.base.BaseProviderFactory;
import org.dromara.sms4j.provider.enumerate.SupplierType;

public abstract class SmsFactory {
    private static final Map<SupplierType, SmsBlend> beans = new HashMap<SupplierType, SmsBlend>();

    private SmsFactory() {
    }

    public static SmsBlend createSmsBlend(SupplierType supplierType) {
        BaseProviderFactory providerFactory = supplierType.getProviderFactory();
        return providerFactory.createSms(providerFactory.getConfig());
    }

    public static SmsBlend createSmsBlend(SupplierType supplierType, SupplierConfig config) {
        BaseProviderFactory providerFactory = supplierType.getProviderFactory();
        return providerFactory.createMultitonSms(config);
    }

    public static void refresh() {
        for (SupplierType type : SupplierType.values()) {
            SmsFactory.refresh(type);
        }
    }

    public static void refresh(SupplierType supplierType) {
        BaseProviderFactory providerFactory = supplierType.getProviderFactory();
        providerFactory.refresh(providerFactory.getConfig());
    }

    public static void refreshSqlConfig() {
        SupplierSqlConfig.refreshSqlConfig();
    }

    public static SmsBlend getRestrictedSmsBlend(SupplierType supplierType) {
        SmsBlend smsBlend = beans.get(supplierType);
        if (Objects.isNull(smsBlend)) {
            smsBlend = SmsFactory.getSmsBlend(supplierType);
            beans.put(supplierType, smsBlend);
        }
        return smsBlend;
    }

    public static void refreshRestrictedSmsBlend(SupplierType supplierType) {
        SmsFactory.refresh(supplierType);
        beans.put(supplierType, SmsFactory.getSmsBlend(supplierType));
    }

    private static SmsBlend getSmsBlend(SupplierType supplierType) {
        SmsBlend sms = SmsFactory.createSmsBlend(supplierType);
        SmsInvocationHandler smsInvocationHandler = SmsInvocationHandler.newSmsInvocationHandler((SmsBlend)sms, (SmsConfig)BeanFactory.getSmsConfig());
        return (SmsBlend)Proxy.newProxyInstance(sms.getClass().getClassLoader(), new Class[]{SmsBlend.class}, (InvocationHandler)smsInvocationHandler);
    }
}

