/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.core.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.dromara.sms4j.api.SmsBlend;
import org.dromara.sms4j.api.proxy.SmsProcessor;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsInvocationHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(SmsInvocationHandler.class);
    private final SmsBlend smsBlend;
    private final LinkedList<SmsProcessor> processors;

    public SmsInvocationHandler(SmsBlend smsBlend, LinkedList<SmsProcessor> processors) {
        this.smsBlend = smsBlend;
        this.processors = processors;
    }

    @Override
    public Object invoke(Object o, Method method, Object[] objects) {
        Object result = null;
        objects = this.doPreProcess(this.smsBlend, method, objects);
        try {
            result = method.invoke((Object)this.smsBlend, objects);
        }
        catch (Exception e) {
            this.doErrorHandleProcess(this.smsBlend, method, objects, e);
            throw new SmsBlendException(e);
        }
        this.doPostrocess(this.smsBlend, method, objects, result);
        return result;
    }

    public Object[] doPreProcess(Object o, Method method, Object[] objects) {
        for (SmsProcessor processor : this.processors) {
            objects = processor.preProcessor(method, o, objects);
        }
        return objects;
    }

    public void doErrorHandleProcess(Object o, Method method, Object[] objects, Exception e) {
        for (SmsProcessor processor : this.processors) {
            processor.exceptionHandleProcessor(method, o, objects, e);
        }
    }

    public Object doPostrocess(Object o, Method method, Object[] objects, Object result) {
        for (SmsProcessor processor : this.processors) {
            Object overrideResult = processor.postProcessor(result, objects);
            if (overrideResult == null) continue;
            return overrideResult;
        }
        return result;
    }
}

