/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.core.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.dromara.sms4j.api.SmsBlend;
import org.dromara.sms4j.api.dao.SmsDao;
import org.dromara.sms4j.api.dao.SmsDaoDefaultImpl;
import org.dromara.sms4j.api.proxy.Order;
import org.dromara.sms4j.api.proxy.SmsProcessor;
import org.dromara.sms4j.api.proxy.SuppotFilter;
import org.dromara.sms4j.api.proxy.aware.SmsBlendConfigAware;
import org.dromara.sms4j.api.proxy.aware.SmsConfigAware;
import org.dromara.sms4j.api.proxy.aware.SmsDaoAware;
import org.dromara.sms4j.core.proxy.EnvirmentHolder;
import org.dromara.sms4j.core.proxy.SmsInvocationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SmsProxyFactory {
    private static final Logger log = LoggerFactory.getLogger(SmsProxyFactory.class);
    private static final LinkedList<SmsProcessor> processors = new LinkedList();

    public static SmsBlend getProxySmsBlend(SmsBlend smsBlend) {
        LinkedList ownerProcessors = processors.stream().filter(processor -> !SmsProxyFactory.shouldSkipProcess(processor, smsBlend)).collect(Collectors.toCollection(LinkedList::new));
        return (SmsBlend)Proxy.newProxyInstance(smsBlend.getClass().getClassLoader(), new Class[]{SmsBlend.class}, (InvocationHandler)new SmsInvocationHandler(smsBlend, ownerProcessors));
    }

    public static void addProcessor(SmsProcessor processor) {
        SmsProxyFactory.processorValidate(processor);
        SmsProxyFactory.awareTransfer(processor);
        processors.add(processor);
        processors.sort(Comparator.comparingInt(Order::getOrder));
    }

    public static boolean shouldSkipProcess(SmsProcessor processor, SmsBlend smsBlend) {
        if (processor instanceof SuppotFilter) {
            List supports = ((SuppotFilter)processor).getSupports();
            boolean exsit = supports.stream().anyMatch(support -> support.equals(smsBlend.getSupplier()));
            return !exsit;
        }
        return false;
    }

    private static void awareTransfer(SmsProcessor processor) {
        if (processor instanceof SmsDaoAware) {
            ((SmsDaoAware)processor).setSmsDao(SmsProxyFactory.getSmsDaoFromFramework());
        }
        if (processor instanceof SmsConfigAware) {
            ((SmsConfigAware)processor).setSmsConfig((Object)EnvirmentHolder.getSmsConfig());
        }
        if (processor instanceof SmsBlendConfigAware) {
            ((SmsBlendConfigAware)processor).setSmsBlendsConfig(EnvirmentHolder.getBlends());
        }
    }

    private static void processorValidate(SmsProcessor processor) {
    }

    private static SmsDao getSmsDaoFromFramework() {
        SmsDao smsDao = SmsProxyFactory.getSmsDaoFromFramework("org.dromara.sms4j.javase.config.SESmsDaoHolder", "JavaSE");
        if (null != smsDao) {
            return smsDao;
        }
        smsDao = SmsProxyFactory.getSmsDaoFromFramework("org.dromara.sms4j.starter.holder.SpringSmsDaoHolder", "SpringBoot");
        if (null != smsDao) {
            return smsDao;
        }
        smsDao = SmsProxyFactory.getSmsDaoFromFramework("org.dromara.sms4j.solon.holder.SolonSmsDaoHolder", "Solon");
        if (null != smsDao) {
            return smsDao;
        }
        log.debug("\u672a\u627e\u5230\u5408\u9002\u6846\u67b6\u52a0\u8f7d\uff0c\u6700\u7ec8\u4f7f\u7528\u9ed8\u8ba4SmsDao\uff01\u5982\u65e0\u81ea\u5b9e\u73b0SmsDao\u8bf7\u5ffd\u7565\u672c\u6d88\u606f\uff01");
        return SmsDaoDefaultImpl.getInstance();
    }

    private static SmsDao getSmsDaoFromFramework(String className, String frameworkName) {
        try {
            Class<?> clazz = Class.forName(className);
            Method getSmsDao = clazz.getMethod("getSmsDao", null);
            SmsDao smsDao = (SmsDao)getSmsDao.invoke(null, null);
            log.debug("{}:\u52a0\u8f7dSmsDao\u6210\u529f\uff0c\u4f7f\u7528{}", (Object)frameworkName, (Object)smsDao.getClass().getName());
            return smsDao;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.debug("{}:\u5c1d\u8bd5\u5176\u4ed6\u6846\u67b6\u52a0\u8f7d......", (Object)frameworkName);
            return null;
        }
    }
}

