/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.core.proxy.processor;

import cn.hutool.core.util.StrUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.dromara.sms4j.api.proxy.CoreMethodProcessor;
import org.dromara.sms4j.api.verify.PhoneVerify;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreMethodParamValidateProcessor
implements CoreMethodProcessor {
    private static final Logger log = LoggerFactory.getLogger(CoreMethodParamValidateProcessor.class);
    private PhoneVerify phoneVerify;

    public CoreMethodParamValidateProcessor(PhoneVerify phoneVerify) {
        this.phoneVerify = phoneVerify;
    }

    public int getOrder() {
        return -1;
    }

    public void sendMessagePreProcess(String phone, Object message) {
        this.validatePhone(phone);
        this.validateMessage(message);
    }

    public void sendMessageByTemplatePreProcess(String phone, String templateId, LinkedHashMap<String, String> messages) {
        this.validatePhone(phone);
        this.validateMessages(templateId, messages);
    }

    public void massTextingPreProcess(List<String> phones, String message) {
        this.validateMessage(message);
        this.validatePhones(phones);
    }

    public void massTextingByTemplatePreProcess(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        this.validatePhones(phones);
        this.validateMessages(templateId, messages);
    }

    public void validateMessage(Object messageObj) {
        String message;
        if (Objects.isNull(messageObj)) {
            throw new SmsBlendException("cant send a null message!");
        }
        if (messageObj instanceof String && StrUtil.isBlank((CharSequence)(message = (String)messageObj))) {
            throw new SmsBlendException("cant send a null message!");
        }
    }

    public void validatePhone(String phone) {
        if (StrUtil.isBlank((CharSequence)phone)) {
            throw new SmsBlendException("cant send message to null!");
        }
        if (this.phoneVerify != null && !this.phoneVerify.verifyPhone(phone)) {
            throw new SmsBlendException("The mobile phone number format is invalid!");
        }
    }

    public void validatePhones(List<String> phones) {
        if (null == phones) {
            throw new SmsBlendException("cant send message to null!");
        }
        for (String phone : phones) {
            if (!StrUtil.isNotBlank((CharSequence)phone) || this.phoneVerify == null || this.phoneVerify.verifyPhone(phone)) continue;
            throw new SmsBlendException("The mobile phone number format is invalid!");
        }
        throw new SmsBlendException("cant send message to null!");
    }

    public void validateMessages(String templateId, LinkedHashMap<String, String> messages) {
        if (StrUtil.isEmpty((CharSequence)templateId)) {
            throw new SmsBlendException("cant use template without template param");
        }
    }

    public void setPhoneVerify(PhoneVerify phoneVerify) {
        this.phoneVerify = phoneVerify;
    }
}

