/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.core.proxy.processor;

import java.lang.reflect.Method;
import java.util.Map;
import org.dromara.sms4j.api.SmsBlend;
import org.dromara.sms4j.api.dao.SmsDao;
import org.dromara.sms4j.api.proxy.SmsProcessor;
import org.dromara.sms4j.api.proxy.aware.SmsBlendConfigAware;
import org.dromara.sms4j.api.proxy.aware.SmsDaoAware;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleBlendRestrictedProcessor
implements SmsProcessor,
SmsDaoAware,
SmsBlendConfigAware {
    private static final Logger log = LoggerFactory.getLogger(SingleBlendRestrictedProcessor.class);
    private static final String REDIS_KEY = "sms:restricted:";
    private SmsDao smsDao;
    Map smsBlendsConfig;

    public int getOrder() {
        return 2;
    }

    public Object[] preProcessor(Method method, Object source, Object[] param) {
        String name = method.getName();
        if (!"sendMessage".equals(name) && !"massText".equals(name)) {
            return param;
        }
        SmsBlend smsBlend = (SmsBlend)source;
        String configId = smsBlend.getConfigId();
        Map targetConfig = (Map)this.smsBlendsConfig.get(configId);
        Object maximumObj = targetConfig.get("maximum");
        if (SmsUtils.isEmpty(maximumObj)) {
            return param;
        }
        int maximum = 0;
        try {
            maximum = Integer.parseInt(String.valueOf(maximumObj));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5382\u5546\u7ea7\u53d1\u9001\u4e0a\u9650\u53c2\u6570\u9519\u8bef\uff01\u8bf7\u68c0\u67e5\uff01");
            throw new IllegalArgumentException("\u83b7\u53d6\u5382\u5546\u7ea7\u53d1\u9001\u4e0a\u9650\u53c2\u6570\u9519\u8bef");
        }
        Integer i = (Integer)this.smsDao.get(REDIS_KEY + configId + "maximum");
        if (SmsUtils.isEmpty((Object)i)) {
            this.smsDao.set(REDIS_KEY + configId + "maximum", (Object)1);
        } else {
            if (i >= maximum) {
                log.info("The channel: {},messages reached the maximum", (Object)configId);
                throw new SmsBlendException("The channel: {},messages reached the maximum", configId);
            }
            this.smsDao.set(REDIS_KEY + configId + "maximum", (Object)(i + 1));
        }
        return param;
    }

    public void setSmsDao(SmsDao smsDao) {
        this.smsDao = smsDao;
    }

    public void setSmsBlendsConfig(Map smsBlendsConfig) {
        this.smsBlendsConfig = smsBlendsConfig;
    }
}

