/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.core.load;

import cn.hutool.core.bean.BeanUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dromara.sms4j.api.SmsBlend;
import org.dromara.sms4j.api.universal.SupplierConfig;
import org.dromara.sms4j.core.load.LoadServer;

public class SmsLoad {
    private final List<LoadServer> LoadServers = new ArrayList<LoadServer>();
    private static final SmsLoad SMS_LOAD = new SmsLoad();

    private SmsLoad() {
    }

    public static SmsLoad newSmsLoad() {
        return new SmsLoad();
    }

    public void addLoadServer(SmsBlend LoadServer2, int weight) {
        this.LoadServers.add(new LoadServer(LoadServer2, weight, weight));
    }

    public void removeLoadServer(SmsBlend LoadServer2) {
        Iterator<LoadServer> iterator = this.LoadServers.iterator();
        while (iterator.hasNext()) {
            LoadServer server = iterator.next();
            if (!server.getSmsServer().getConfigId().equals(LoadServer2.getConfigId())) continue;
            iterator.remove();
            break;
        }
    }

    public synchronized SmsBlend getLoadServer() {
        int totalWeight = 0;
        LoadServer selectedLoadServer = null;
        for (LoadServer LoadServer2 : this.LoadServers) {
            totalWeight += LoadServer2.getWeight();
            int currentWeight = LoadServer2.getCurrentWeight() + LoadServer2.getWeight();
            LoadServer2.setCurrentWeight(currentWeight);
            if (selectedLoadServer != null && LoadServer2.getCurrentWeight() <= selectedLoadServer.getCurrentWeight()) continue;
            selectedLoadServer = LoadServer2;
        }
        if (selectedLoadServer == null) {
            return null;
        }
        int i = selectedLoadServer.getCurrentWeight() - totalWeight;
        selectedLoadServer.setCurrentWeight(i);
        return selectedLoadServer.getSmsServer();
    }

    public static void starConfig(SmsBlend smsBlend, SupplierConfig supplierConfig) {
        Map supplierConfigMap = BeanUtil.beanToMap((Object)supplierConfig, (String[])new String[0]);
        Integer weight = supplierConfigMap.getOrDefault("weight", 1);
        SMS_LOAD.addLoadServer(smsBlend, Integer.parseInt(((Object)weight).toString()));
    }

    public static void starConfig(SmsBlend smsBlend, Integer weight) {
        SMS_LOAD.addLoadServer(smsBlend, weight);
    }

    public static SmsLoad getBeanLoad() {
        return SMS_LOAD;
    }
}

