/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.core.factory;

import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.dromara.sms4j.api.SmsBlend;
import org.dromara.sms4j.api.universal.SupplierConfig;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.core.datainterface.SmsReadConfig;
import org.dromara.sms4j.core.load.SmsLoad;
import org.dromara.sms4j.core.proxy.SmsProxyFactory;
import org.dromara.sms4j.provider.config.BaseConfig;
import org.dromara.sms4j.provider.factory.BaseProviderFactory;
import org.dromara.sms4j.provider.factory.ProviderFactoryHolder;

public abstract class SmsFactory {
    private static final Map<String, SmsBlend> BLENDS = new ConcurrentHashMap<String, SmsBlend>();

    private SmsFactory() {
    }

    public static void createSmsBlend(SupplierConfig config) {
        SmsBlend smsBlend = SmsFactory.create(config);
        SmsFactory.register(smsBlend);
    }

    public static void createSmsBlend(SmsReadConfig smsReadConfig, String configId) {
        BaseConfig supplierConfig = smsReadConfig.getSupplierConfig(configId);
        SmsBlend smsBlend = SmsFactory.create((SupplierConfig)supplierConfig);
        SmsFactory.register(smsBlend);
    }

    public static void createSmsBlend(SmsReadConfig smsReadConfig) {
        List<BaseConfig> supplierConfigList = smsReadConfig.getSupplierConfigList();
        supplierConfigList.forEach(supplierConfig -> {
            SmsBlend smsBlend = SmsFactory.create((SupplierConfig)supplierConfig);
            SmsFactory.register(smsBlend);
        });
    }

    @Deprecated
    public static void createRestrictedSmsBlend(SupplierConfig config) {
        SmsBlend smsBlend = SmsFactory.create(config);
        SmsFactory.register(smsBlend);
    }

    @Deprecated
    public static void createRestrictedSmsBlend(SmsReadConfig smsReadConfig, String configId) {
        BaseConfig supplierConfig = smsReadConfig.getSupplierConfig(configId);
        SmsBlend smsBlend = SmsFactory.create((SupplierConfig)supplierConfig);
        SmsFactory.register(smsBlend);
    }

    @Deprecated
    public static void createRestrictedSmsBlend(SmsReadConfig smsReadConfig) {
        List<BaseConfig> supplierConfigList = smsReadConfig.getSupplierConfigList();
        supplierConfigList.forEach(supplierConfig -> {
            SmsBlend smsBlend = SmsFactory.create((SupplierConfig)supplierConfig);
            SmsFactory.register(smsBlend);
        });
    }

    private static SmsBlend create(SupplierConfig config) {
        BaseProviderFactory factory = ProviderFactoryHolder.requireForSupplier((String)config.getSupplier());
        if (factory == null) {
            throw new SmsBlendException("\u4e0d\u652f\u6301\u5f53\u524d\u4f9b\u5e94\u5546\u914d\u7f6e");
        }
        SmsBlend sms = factory.createSms(config);
        return SmsFactory.renderWithProxy(sms);
    }

    @Deprecated
    private static SmsBlend renderWithProxy(SmsBlend sms) {
        return SmsProxyFactory.getProxySmsBlend(sms);
    }

    public static SmsBlend getSmsBlend() {
        return SmsLoad.getBeanLoad().getLoadServer();
    }

    public static SmsBlend getSmsBlend(String configId) {
        return BLENDS.get(configId);
    }

    public static SmsBlend getBySupplier(String supplier) {
        if (StrUtil.isEmpty((CharSequence)supplier)) {
            throw new SmsBlendException("\u4f9b\u5e94\u5546\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return BLENDS.values().stream().filter(smsBlend -> supplier.equals(smsBlend.getSupplier())).findFirst().orElse(null);
    }

    public static List<SmsBlend> getListBySupplier(String supplier) {
        if (StrUtil.isEmpty((CharSequence)supplier)) {
            throw new SmsBlendException("\u4f9b\u5e94\u5546\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<SmsBlend> list = BLENDS.values().stream().filter(smsBlend -> supplier.equals(smsBlend.getSupplier())).collect(Collectors.toList());
        return list;
    }

    public static List<SmsBlend> getAll() {
        return new ArrayList<SmsBlend>(BLENDS.values());
    }

    public static void register(SmsBlend smsBlend) {
        if (smsBlend == null) {
            throw new SmsBlendException("\u77ed\u4fe1\u670d\u52a1\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BLENDS.put(smsBlend.getConfigId(), smsBlend);
        SmsLoad.starConfig(smsBlend, 1);
    }

    public static void register(SmsBlend smsBlend, Integer weight) {
        if (smsBlend == null) {
            throw new SmsBlendException("\u77ed\u4fe1\u670d\u52a1\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BLENDS.put(smsBlend.getConfigId(), smsBlend);
        SmsLoad.starConfig(smsBlend, weight);
    }

    public static boolean registerIfAbsent(SmsBlend smsBlend) {
        if (smsBlend == null) {
            throw new SmsBlendException("\u77ed\u4fe1\u670d\u52a1\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String configId = smsBlend.getConfigId();
        if (BLENDS.containsKey(configId)) {
            return false;
        }
        BLENDS.put(configId, smsBlend);
        SmsLoad.starConfig(smsBlend, 1);
        return true;
    }

    public static boolean registerIfAbsent(SmsBlend smsBlend, Integer weight) {
        if (smsBlend == null) {
            throw new SmsBlendException("\u77ed\u4fe1\u670d\u52a1\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String configId = smsBlend.getConfigId();
        if (BLENDS.containsKey(configId)) {
            return false;
        }
        BLENDS.put(configId, smsBlend);
        SmsLoad.starConfig(smsBlend, weight);
        return true;
    }

    public static boolean unregister(String configId) {
        SmsBlend blend = BLENDS.remove(configId);
        SmsLoad.getBeanLoad().removeLoadServer(blend);
        return blend != null;
    }

    public static void reload(String configId, SmsReadConfig smsReadConfig) {
        SmsFactory.unregister(configId);
        SmsFactory.createRestrictedSmsBlend(smsReadConfig, configId);
    }

    public static void reloadAll(SmsReadConfig smsReadConfig) {
        List<BaseConfig> supplierConfigList = smsReadConfig.getSupplierConfigList();
        for (BaseConfig baseConfig : supplierConfigList) {
            SmsFactory.reload(baseConfig.getConfigId(), smsReadConfig);
        }
    }
}

