/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.core.proxy.processor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.dromara.sms4j.api.dao.SmsDao;
import org.dromara.sms4j.api.proxy.SmsProcessor;
import org.dromara.sms4j.api.proxy.aware.SmsConfigAware;
import org.dromara.sms4j.api.proxy.aware.SmsDaoAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlackListRecordingProcessor
implements SmsProcessor,
SmsDaoAware,
SmsConfigAware {
    private static final Logger log = LoggerFactory.getLogger(BlackListRecordingProcessor.class);
    SmsDao smsDao;
    Object smsConfig;

    public int getOrder() {
        return 1;
    }

    public Object[] preProcessor(Method method, Object source, Object[] param) {
        ArrayList<String> blackList;
        String cacheKey;
        if ("joinInBlacklist".equals(method.getName())) {
            cacheKey = this.getCacheKey();
            blackList = this.getBlackList(cacheKey);
            blackList.add((String)param[0]);
            this.flushBlackList(cacheKey, blackList);
        }
        if ("removeFromBlacklist".equals(method.getName())) {
            cacheKey = this.getCacheKey();
            blackList = this.getBlackList(cacheKey);
            blackList.remove((String)param[0]);
            this.flushBlackList(cacheKey, blackList);
        }
        if ("batchJoinBlacklist".equals(method.getName())) {
            cacheKey = this.getCacheKey();
            blackList = this.getBlackList(cacheKey);
            blackList.addAll((List)param[0]);
            this.flushBlackList(cacheKey, blackList);
        }
        if ("batchRemovalFromBlacklist".equals(method.getName())) {
            cacheKey = this.getCacheKey();
            blackList = this.getBlackList(cacheKey);
            blackList.removeAll((List)param[0]);
            this.flushBlackList(cacheKey, blackList);
        }
        return param;
    }

    public String getCacheKey() {
        return "sms:blacklist:global";
    }

    public ArrayList<String> getBlackList(String cacheKey) {
        Object cache = this.smsDao.get(cacheKey);
        if (null != cache) {
            ArrayList blackList = (ArrayList)cache;
            return blackList;
        }
        ArrayList<String> blackList = new ArrayList<String>();
        this.smsDao.set("sms:blacklist:global", blackList);
        return blackList;
    }

    public void flushBlackList(String cacheKey, ArrayList<String> blackList) {
        this.smsDao.set(cacheKey, blackList);
    }

    public void setSmsDao(SmsDao smsDao) {
        this.smsDao = smsDao;
    }

    public void setSmsConfig(Object smsConfig) {
        this.smsConfig = smsConfig;
    }
}

