/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.oa.core.byteTalk.service;

import cn.hutool.json.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.dromara.oa.comm.entity.Request;
import org.dromara.oa.comm.entity.Response;
import org.dromara.oa.comm.enums.MessageType;
import org.dromara.oa.comm.enums.OaType;
import org.dromara.oa.comm.errors.OaException;
import org.dromara.oa.core.byteTalk.config.ByteTalkConfig;
import org.dromara.oa.core.byteTalk.utils.ByteTalkBuilder;
import org.dromara.oa.core.provider.service.AbstractOaBlend;
import org.dromara.oa.core.support.HttpClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteTalkOaImpl
extends AbstractOaBlend<ByteTalkConfig> {
    private static final Logger log = LoggerFactory.getLogger(ByteTalkOaImpl.class);
    private final HttpClientImpl httpClient = new HttpClientImpl();

    public ByteTalkOaImpl(ByteTalkConfig config) {
        super(config);
    }

    public String getSupplier() {
        return OaType.BYTE_TALK.getType();
    }

    public Response sender(Request request, MessageType messageType) {
        String post;
        if (Objects.isNull(request.getContent())) {
            throw new OaException("\u6d88\u606f\u4f53content\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder webhook = new StringBuilder();
        JSONObject message = null;
        ByteTalkConfig config = (ByteTalkConfig)this.getConfig();
        webhook.append(OaType.BYTE_TALK.getUrl());
        webhook.append(config.getTokenId());
        long now = System.currentTimeMillis() / 1000L;
        String sign = ByteTalkBuilder.byteTalkSign(config.getSign(), now);
        message = ByteTalkBuilder.createByteTalkMessage(request, messageType, sign, now);
        try {
            post = this.httpClient.post(webhook, ByteTalkOaImpl.getHeaders(), message);
            log.info("\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\uff1a" + post);
        }
        catch (Exception e) {
            log.warn("\u8bf7\u6c42\u5931\u8d25\u95ee\u9898\uff1a" + e.getMessage());
            throw new OaException(e.getMessage());
        }
        return new Response(true, (Object)post, config.getConfigId());
    }

    public static Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        return headers;
    }
}

