/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.oa.core.byteTalk.utils;

import cn.hutool.core.codec.Base64;
import cn.hutool.crypto.digest.HMac;
import cn.hutool.crypto.digest.HmacAlgorithm;
import cn.hutool.json.JSONObject;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.dromara.oa.comm.entity.Request;
import org.dromara.oa.comm.enums.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteTalkBuilder {
    private static final Logger log = LoggerFactory.getLogger(ByteTalkBuilder.class);

    public static String byteTalkSign(String secret, Long timestamp) {
        String stringToSign = timestamp + "\n" + secret;
        HMac mac = new HMac(HmacAlgorithm.HmacSHA256, stringToSign.getBytes(StandardCharsets.UTF_8));
        byte[] signData = mac.digest(new byte[0]);
        return Base64.encode((byte[])signData);
    }

    public static JSONObject createByteTalkMessage(Request request, MessageType messageType, String sign, Long timestamp) {
        JSONObject message = new JSONObject();
        List userIdList = request.getUserIdList();
        if (messageType == MessageType.BYTE_TALK_TEXT) {
            message.set("msg_type", (Object)"text");
            message.set("timestamp", (Object)timestamp);
            message.set("sign", (Object)sign);
            StringBuilder content = new StringBuilder();
            Boolean isNoticeAll = request.getIsNoticeAll();
            boolean isNotice = false;
            if (!Objects.isNull(isNoticeAll) && isNoticeAll.booleanValue()) {
                content.append("<at user_id=\"all\">\u6240\u6709\u4eba</at>");
                isNotice = true;
            }
            if (!Objects.isNull(userIdList)) {
                userIdList.forEach(l -> content.append("<at user_id=\"").append((String)l).append("\"></at>"));
                isNotice = true;
            }
            if (isNotice) {
                content.append("\n");
            }
            content.append(request.getContent());
            JSONObject text = new JSONObject();
            text.set("text", (Object)content);
            message.set("content", (Object)text);
        } else {
            log.error("\u8f93\u5165\u7684\u6d88\u606f\u683c\u5f0f\u4e0d\u5bf9,message:" + messageType + "\u5e94\u8be5\u4f7f\u7528BYTETALK\u524d\u7f00\u7684\u6d88\u606f\u7c7b\u578b");
        }
        return message;
    }
}

