/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.oa.core.config;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.util.List;
import java.util.Map;
import org.dromara.oa.api.OaSender;
import org.dromara.oa.comm.config.OaSupplierConfig;
import org.dromara.oa.core.byteTalk.config.ByteTalkFactory;
import org.dromara.oa.core.dingTalk.config.DingTalkFactory;
import org.dromara.oa.core.provider.config.OaConfig;
import org.dromara.oa.core.provider.factory.OaBaseProviderFactory;
import org.dromara.oa.core.provider.factory.OaFactory;
import org.dromara.oa.core.provider.factory.ProviderFactoryHolder;
import org.dromara.oa.core.weTalk.config.WeTalkFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OaBlendsInitializer {
    private static final Logger log = LoggerFactory.getLogger(OaBlendsInitializer.class);
    private final List<OaBaseProviderFactory<? extends OaSender, ? extends OaSupplierConfig>> factoryList;
    private final OaConfig oaConfig;
    private final Map<String, Map<String, Object>> blends;

    public OaBlendsInitializer(List<OaBaseProviderFactory<? extends OaSender, ? extends OaSupplierConfig>> factoryList, OaConfig oaConfig, Map<String, Map<String, Object>> oas) {
        this.factoryList = factoryList;
        this.oaConfig = oaConfig;
        this.blends = oas;
        this.onApplicationEvent();
    }

    public void onApplicationEvent() {
        this.registerDefaultFactory();
        for (String configId : this.blends.keySet()) {
            Map<String, Object> configMap = this.blends.get(configId);
            if (Boolean.FALSE.equals(configMap.get("isEnable"))) {
                log.warn("configId\u4e3a" + configId + "\u7684\u914d\u7f6e\u672a\u542f\u7528,\u8bf7\u6ce8\u610f\u662f\u5426\u9700\u8981\u5f00\u542f");
                continue;
            }
            Object supplierObj = configMap.get("supplier");
            String supplier = supplierObj == null ? "" : String.valueOf(supplierObj);
            OaBaseProviderFactory<? extends OaSender, ? extends OaSupplierConfig> providerFactory = ProviderFactoryHolder.requireForSupplier(supplier = StrUtil.isEmpty((CharSequence)supplier) ? configId : supplier);
            if (providerFactory == null) {
                log.warn("\u521b\u5efa\"{}\"\u7684\u901a\u77e5webhook\u670d\u52a1\u5931\u8d25\uff0c\u672a\u627e\u5230\u4f9b\u5e94\u5546\u4e3a\"{}\"\u7684\u670d\u52a1", (Object)configId, (Object)supplier);
                continue;
            }
            configMap.put("configId", configId);
            JSONObject configJson = new JSONObject(configMap);
            OaSupplierConfig supplierConfig = (OaSupplierConfig)JSONUtil.toBean((JSONObject)configJson, providerFactory.getConfigClass());
            OaFactory.createAndRegisterOaSender(supplierConfig);
        }
    }

    private void registerDefaultFactory() {
        ProviderFactoryHolder.registerFactory(DingTalkFactory.instance());
        ProviderFactoryHolder.registerFactory(ByteTalkFactory.instance());
        ProviderFactoryHolder.registerFactory(WeTalkFactory.instance());
    }
}

