/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.oa.core.config;

import java.util.concurrent.Executor;
import org.dromara.oa.comm.task.delayed.DelayedTime;
import org.dromara.oa.core.provider.config.OaConfig;
import org.dromara.oa.core.provider.factory.OaBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;

public class OaMainConfig {
    @Bean
    @ConfigurationProperties(prefix="sms-oa")
    @ConditionalOnProperty(prefix="sms-oa", name={"config-type"}, havingValue="yaml")
    protected OaConfig oaConfig() {
        return OaBeanFactory.getSmsConfig();
    }

    @Bean(value={"oaDelayedTime"})
    @Lazy
    protected DelayedTime delayedTime() {
        return OaBeanFactory.getDelayedTime();
    }

    @Bean(value={"oaExecutor"})
    protected Executor taskExecutor(OaConfig config) {
        return OaBeanFactory.setExecutor(config);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OaMainConfig)) {
            return false;
        }
        OaMainConfig other = (OaMainConfig)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof OaMainConfig;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "OaMainConfig()";
    }
}

