/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.oa.core.dingTalk.utils;

import cn.hutool.core.codec.Base64;
import cn.hutool.crypto.digest.HMac;
import cn.hutool.crypto.digest.HmacAlgorithm;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.dromara.oa.comm.entity.Request;
import org.dromara.oa.comm.enums.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingTalkBuilder {
    private static final Logger log = LoggerFactory.getLogger(DingTalkBuilder.class);

    public static String sign(String secret) {
        String sign;
        Long timestamp = System.currentTimeMillis();
        String stringToSign = timestamp + "\n" + secret;
        HMac mac = new HMac(HmacAlgorithm.HmacSHA256, secret.getBytes(StandardCharsets.UTF_8));
        byte[] signData = mac.digest(stringToSign.getBytes(StandardCharsets.UTF_8));
        try {
            sign = URLEncoder.encode(Base64.encode((byte[])signData), StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return "&timestamp=" + timestamp + "&sign=" + sign;
    }

    public static JSONObject createMessage(Request request, MessageType messageType) {
        JSONObject message = new JSONObject();
        if (messageType == MessageType.DING_TALK_TEXT) {
            message.set("msgtype", (Object)"text");
            JSONObject text = new JSONObject();
            text.set("content", (Object)request.getContent());
            message.set("text", (Object)text);
        } else if (messageType == MessageType.DING_TALK_MARKDOWN) {
            message.set("msgtype", (Object)"markdown");
            JSONObject markdown = new JSONObject();
            markdown.set("text", (Object)request.getContent());
            markdown.set("title", (Object)request.getTitle());
            message.set("markdown", (Object)markdown);
        } else if (messageType == MessageType.DING_TALK_LINK) {
            message.set("msgtype", (Object)"link");
            JSONObject link = new JSONObject();
            link.set("text", (Object)request.getContent());
            link.set("title", (Object)request.getTitle());
            link.set("picUrl", (Object)request.getPicUrl());
            link.set("messageUrl", (Object)request.getMessageUrl());
            message.set("link", (Object)link);
        } else {
            log.error("\u8f93\u5165\u7684\u6d88\u606f\u683c\u5f0f\u4e0d\u5bf9,message:" + messageType + "\u5e94\u8be5\u4f7f\u7528DINGTALK\u524d\u7f00\u7684\u6d88\u606f\u7c7b\u578b");
        }
        JSONObject at = new JSONObject();
        List phoneList = request.getPhoneList();
        List userIdList = request.getUserIdList();
        if (!Objects.isNull(phoneList)) {
            JSONArray phoneArray = new JSONArray();
            phoneList.forEach(arg_0 -> ((JSONArray)phoneArray).set(arg_0));
            at.set("atMobiles", (Object)phoneArray);
        }
        if (!Objects.isNull(userIdList)) {
            JSONArray userIdArray = new JSONArray();
            userIdList.forEach(arg_0 -> ((JSONArray)userIdArray).set(arg_0));
            at.set("atUserIds", (Object)userIdArray);
        }
        at.set("isAtAll", (Object)request.getIsNoticeAll());
        message.set("at", (Object)at);
        return message;
    }
}

