/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.oa.core.provider.factory;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dromara.oa.comm.entity.Request;
import org.dromara.oa.comm.task.delayed.DelayedTime;
import org.dromara.oa.core.provider.config.OaConfig;

public class OaBeanFactory {
    private static DelayedTime delayedTime;
    private static Executor executor;
    private static OaConfig oaConfig;
    private static PriorityBlockingQueue<Request> priorityBlockingQueue;
    private static Boolean priorityExecutorThreadStatus;

    private OaBeanFactory() {
    }

    public static DelayedTime getDelayedTime() {
        if (delayedTime == null) {
            delayedTime = new DelayedTime();
        }
        return delayedTime;
    }

    public static Executor setExecutor(OaConfig config) {
        if (executor == null) {
            ThreadPoolExecutor ex = new ThreadPoolExecutor(config.getCorePoolSize(), config.getMaxPoolSize(), config.getQueueCapacity().intValue(), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(config.getMaxPoolSize()));
            ex.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
            executor = ex;
        }
        return executor;
    }

    public static PriorityBlockingQueue<Request> initPriorityBlockingQueue() {
        if (priorityBlockingQueue == null) {
            priorityBlockingQueue = new PriorityBlockingQueue();
        }
        return priorityBlockingQueue;
    }

    public static OaConfig getSmsConfig() {
        if (oaConfig == null) {
            oaConfig = new OaConfig();
        }
        return oaConfig;
    }

    public static Boolean setPriorityExecutorThreadStatus(Boolean bo) {
        priorityExecutorThreadStatus = bo;
        return priorityExecutorThreadStatus;
    }

    public static Executor getExecutor() {
        return executor;
    }

    public static PriorityBlockingQueue<Request> getPriorityBlockingQueue() {
        return priorityBlockingQueue;
    }

    public static Boolean getPriorityExecutorThreadStatus() {
        return priorityExecutorThreadStatus;
    }

    static {
        priorityExecutorThreadStatus = false;
    }
}

