/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.oa.core.provider.factory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dromara.oa.api.OaSender;
import org.dromara.oa.comm.config.OaSupplierConfig;
import org.dromara.oa.comm.errors.OaException;
import org.dromara.oa.core.provider.factory.OaBaseProviderFactory;
import org.dromara.oa.core.provider.factory.ProviderFactoryHolder;

public class OaFactory {
    private static final Map<String, OaSender> CONFIGS = new ConcurrentHashMap<String, OaSender>();

    public static void createAndRegisterOaSender(OaSupplierConfig config) {
        OaSender oaSender = OaFactory.createAndGetOa(config);
        OaFactory.register(oaSender);
    }

    public static void register(OaSender smsBlend) {
        if (smsBlend == null) {
            throw new OaException("\u901a\u77e5webhook\u670d\u52a1\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CONFIGS.put(smsBlend.getConfigId(), smsBlend);
    }

    public static OaSender createAndGetOa(OaSupplierConfig config) {
        OaBaseProviderFactory<? extends OaSender, ? extends OaSupplierConfig> factory = ProviderFactoryHolder.requireForSupplier(config.getSupplier());
        if (factory == null) {
            throw new OaException("\u4e0d\u652f\u6301" + config.getSupplier() + "\u4f9b\u5e94\u5546\u914d\u7f6e");
        }
        return factory.createSmsOa((OaSupplierConfig)config);
    }

    public static OaSender getSmsOaBlend(String configId) {
        return CONFIGS.get(configId);
    }
}

