/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.oa.core.provider.factory;

import cn.hutool.core.collection.CollUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dromara.oa.api.OaSender;
import org.dromara.oa.comm.config.OaSupplierConfig;
import org.dromara.oa.comm.errors.OaException;
import org.dromara.oa.core.provider.factory.OaBaseProviderFactory;

public class ProviderFactoryHolder {
    private static final Map<String, OaBaseProviderFactory<? extends OaSender, ? extends OaSupplierConfig>> FACTORIES = new ConcurrentHashMap<String, OaBaseProviderFactory<? extends OaSender, ? extends OaSupplierConfig>>();

    public static void registerFactory(OaBaseProviderFactory<? extends OaSender, ? extends OaSupplierConfig> factory) {
        if (factory == null) {
            throw new OaException("\u6ce8\u518c\u4f9b\u5e94\u5546\u5de5\u5382\u5931\u8d25\uff0c\u5de5\u5382\u5b9e\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FACTORIES.put(factory.getSupplier(), factory);
    }

    public static void registerFactory(List<OaBaseProviderFactory<? extends OaSender, ? extends OaSupplierConfig>> factoryList) {
        if (CollUtil.isEmpty(factoryList)) {
            return;
        }
        for (OaBaseProviderFactory<? extends OaSender, ? extends OaSupplierConfig> factory : factoryList) {
            if (factory == null) continue;
            ProviderFactoryHolder.registerFactory(factory);
        }
    }

    public static OaBaseProviderFactory<? extends OaSender, ? extends OaSupplierConfig> requireForSupplier(String supplier) {
        return FACTORIES.getOrDefault(supplier, null);
    }
}

