/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.oa.core.provider.service;

import cn.hutool.core.util.StrUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.PriorityBlockingQueue;
import org.dromara.oa.api.OaCallBack;
import org.dromara.oa.api.OaSender;
import org.dromara.oa.comm.config.OaSupplierConfig;
import org.dromara.oa.comm.entity.Request;
import org.dromara.oa.comm.entity.Response;
import org.dromara.oa.comm.enums.MessageType;
import org.dromara.oa.core.provider.factory.OaBeanFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOaBlend<C extends OaSupplierConfig>
implements OaSender {
    private static final Logger log = LoggerFactory.getLogger(AbstractOaBlend.class);
    private final String configId;
    private final C config;
    protected final Executor pool;
    protected final PriorityBlockingQueue<Request> priorityQueueMap;

    protected AbstractOaBlend(C config, Executor pool) {
        this.configId = StrUtil.isEmpty((CharSequence)config.getConfigId()) ? this.getSupplier() : config.getConfigId();
        this.config = config;
        this.pool = pool;
        this.priorityQueueMap = OaBeanFactory.initPriorityBlockingQueue();
        this.priorityQueueMapThreadInit();
    }

    protected AbstractOaBlend(C config) {
        this.configId = StrUtil.isEmpty((CharSequence)config.getConfigId()) ? this.getSupplier() : config.getConfigId();
        this.config = config;
        this.pool = OaBeanFactory.getExecutor();
        this.priorityQueueMap = OaBeanFactory.initPriorityBlockingQueue();
        this.priorityQueueMapThreadInit();
    }

    protected C getConfig() {
        return this.config;
    }

    protected void priorityQueueMapThreadInit() {
        Boolean status = OaBeanFactory.getPriorityExecutorThreadStatus();
        if (Boolean.FALSE.equals(status)) {
            OaBeanFactory.setPriorityExecutorThreadStatus(true);
            this.pool.execute(() -> {
                Thread.currentThread().setName("oa-priorityQueueMap-thread");
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Request request = this.priorityQueueMap.take();
                        this.pool.execute(() -> {
                            log.info("\u4f18\u5148\u7ea7\u4e3a" + request.getPriority() + "\u5df2\u53d1\u9001");
                            this.sender(request, request.getMessageType());
                        });
                    }
                    catch (InterruptedException e) {
                        log.info("[Dispatcher]-priorityQueueMap-task-dispatcher has been interrupt to close.");
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            });
        }
    }

    public final void senderAsync(Request request, MessageType messageType) {
        this.pool.execute(() -> this.sender(request, messageType));
    }

    public final void senderAsync(Request request, MessageType messageType, OaCallBack callBack) {
        CompletableFuture<Response> future = CompletableFuture.supplyAsync(() -> this.sender(request, messageType));
        future.thenAcceptAsync(arg_0 -> ((OaCallBack)callBack).callBack(arg_0));
    }

    public final void senderAsyncByPriority(Request request, MessageType messageType) {
        request.setMessageType(messageType);
        this.priorityQueueMap.offer(request);
    }

    public String getConfigId() {
        return this.configId;
    }
}

