/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.oa.core.weTalk.service;

import cn.hutool.json.JSONObject;
import java.util.HashMap;
import java.util.Map;
import org.dromara.oa.comm.entity.Request;
import org.dromara.oa.comm.entity.Response;
import org.dromara.oa.comm.enums.MessageType;
import org.dromara.oa.comm.enums.OaType;
import org.dromara.oa.comm.errors.OaException;
import org.dromara.oa.core.provider.service.AbstractOaBlend;
import org.dromara.oa.core.support.HttpClientImpl;
import org.dromara.oa.core.weTalk.config.WeTalkConfig;
import org.dromara.oa.core.weTalk.utils.WeTalkBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeTalkOaImpl
extends AbstractOaBlend<WeTalkConfig> {
    private static final Logger log = LoggerFactory.getLogger(WeTalkOaImpl.class);
    private final HttpClientImpl httpClient = new HttpClientImpl();

    public WeTalkOaImpl(WeTalkConfig config) {
        super(config);
    }

    public String getSupplier() {
        return OaType.WE_TALK.getType();
    }

    public Response sender(Request request, MessageType messageType) {
        String post;
        StringBuilder webhook = new StringBuilder();
        JSONObject message = null;
        WeTalkConfig config = (WeTalkConfig)this.getConfig();
        webhook.append(OaType.WE_TALK.getUrl());
        webhook.append(config.getTokenId());
        message = WeTalkBuilder.createWeTalkMessage(request, messageType);
        try {
            post = this.httpClient.post(webhook, WeTalkOaImpl.getHeaders(), message);
            log.info("\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\uff1a" + post);
        }
        catch (Exception e) {
            log.warn("\u8bf7\u6c42\u5931\u8d25\u95ee\u9898\uff1a" + e.getMessage());
            throw new OaException(e.getMessage());
        }
        return new Response(true, (Object)post, config.getConfigId());
    }

    public static Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        return headers;
    }
}

