/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.oa.core.weTalk.utils;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import java.util.List;
import java.util.Objects;
import org.dromara.oa.comm.entity.Request;
import org.dromara.oa.comm.enums.MessageType;
import org.dromara.oa.comm.errors.OaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeTalkBuilder {
    private static final Logger log = LoggerFactory.getLogger(WeTalkBuilder.class);

    public static JSONObject createWeTalkMessage(Request request, MessageType messageType) {
        JSONObject message = new JSONObject();
        List userIdList = request.getUserIdList();
        List phoneList = request.getPhoneList();
        StringBuilder content = new StringBuilder();
        Boolean isNoticeAll = request.getIsNoticeAll();
        if (messageType == MessageType.WE_TALK_TEXT) {
            JSONArray userIdArray;
            if (Objects.isNull(request.getContent())) {
                throw new OaException("\u6d88\u606f\u4f53content\u4e0d\u80fd\u4e3a\u7a7a");
            }
            message.set("msgtype", (Object)"text");
            JSONObject text = new JSONObject();
            text.set("content", (Object)request.getContent());
            boolean isContain = false;
            if (isNoticeAll.booleanValue() && ObjectUtil.isNull((Object)userIdList) && ObjectUtil.isNull((Object)phoneList)) {
                userIdArray = new JSONArray();
                userIdArray.add((Object)"@all");
                text.set("mentioned_list", (Object)userIdArray);
            }
            if (!ObjectUtil.isNull((Object)userIdList)) {
                userIdArray = new JSONArray();
                userIdList.forEach(arg_0 -> ((JSONArray)userIdArray).set(arg_0));
                if (isNoticeAll.booleanValue()) {
                    userIdArray.add((Object)"@all");
                    isContain = true;
                }
                text.set("mentioned_list", (Object)userIdArray);
            }
            if (!ObjectUtil.isNull((Object)phoneList)) {
                JSONArray phoneArray = new JSONArray();
                phoneList.forEach(arg_0 -> ((JSONArray)phoneArray).set(arg_0));
                if (isNoticeAll.booleanValue() && !isContain) {
                    phoneArray.add((Object)"@all");
                }
                text.set("mentioned_mobile_list", (Object)phoneArray);
            }
            message.set("text", (Object)text);
        } else if (messageType == MessageType.WE_TALK_MARKDOWN) {
            if (Objects.isNull(request.getContent())) {
                throw new OaException("\u6d88\u606f\u4f53content\u4e0d\u80fd\u4e3a\u7a7a");
            }
            message.set("msgtype", (Object)"markdown");
            if (!Objects.isNull(userIdList)) {
                userIdList.forEach(l -> content.append("<@").append((String)l).append(">"));
                content.append("\n");
            }
            content.append(request.getContent());
            JSONObject markdown = new JSONObject();
            markdown.set("content", (Object)content);
            markdown.set("title", (Object)request.getTitle());
            message.set("markdown", (Object)markdown);
        } else if (messageType == MessageType.WE_TALK_NEWS) {
            message.set("msgtype", (Object)"news");
            JSONObject news = new JSONObject();
            JSONArray articles = new JSONArray();
            List articleList = request.getArticleList();
            if (!articleList.isEmpty()) {
                articleList.forEach(article -> {
                    JSONObject articleJson = new JSONObject();
                    articleJson.set("title", (Object)article.getTitle());
                    articleJson.set("description", (Object)article.getDescription());
                    articleJson.set("url", (Object)article.getUrl());
                    articleJson.set("picurl", (Object)article.getPicUrl());
                    articles.add((Object)articleJson);
                });
            }
            news.set("articles", (Object)articles);
            message.set("news", (Object)news);
        } else {
            log.error("\u8f93\u5165\u7684\u6d88\u606f\u683c\u5f0f\u4e0d\u5bf9,message:" + messageType + "\u5e94\u8be5\u4f7f\u7528WE_TALK\u524d\u7f00\u7684\u6d88\u606f\u7c7b\u578b");
        }
        return message;
    }
}

