/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.cloopen.config;

import org.dromara.sms4j.cloopen.config.CloopenConfig;
import org.dromara.sms4j.cloopen.service.CloopenSmsImpl;
import org.dromara.sms4j.comm.factory.BeanFactory;
import org.dromara.sms4j.provider.base.BaseProviderFactory;

public class CloopenFactory
implements BaseProviderFactory<CloopenSmsImpl, CloopenConfig> {
    private static CloopenSmsImpl cloopenSms;
    private static final CloopenFactory INSTANCE;

    public static CloopenFactory instance() {
        return INSTANCE;
    }

    @Override
    public CloopenSmsImpl createSms(CloopenConfig cloopenConfig) {
        if (cloopenSms == null) {
            cloopenSms = this.createMultitonSms(cloopenConfig);
        }
        return cloopenSms;
    }

    @Override
    public CloopenSmsImpl createMultitonSms(CloopenConfig cloopenConfig) {
        return new CloopenSmsImpl(cloopenConfig, BeanFactory.getExecutor(), BeanFactory.getDelayedTime());
    }

    @Override
    public CloopenSmsImpl refresh(CloopenConfig cloopenConfig) {
        cloopenSms = new CloopenSmsImpl(cloopenConfig, BeanFactory.getExecutor(), BeanFactory.getDelayedTime());
        return cloopenSms;
    }

    @Override
    public CloopenConfig getConfig() {
        return ConfigHolder.config;
    }

    @Override
    public void setConfig(CloopenConfig config) {
        ConfigHolder.config = config;
    }

    private CloopenFactory() {
    }

    static {
        INSTANCE = new CloopenFactory();
    }

    private static final class ConfigHolder {
        private static CloopenConfig config = CloopenConfig.builder().build();

        private ConfigHolder() {
        }
    }
}

