/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.ctyun.service;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.dromara.sms4j.api.AbstractSmsBlend;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.comm.annotation.Restricted;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtil;
import org.dromara.sms4j.ctyun.config.CtyunConfig;
import org.dromara.sms4j.ctyun.utils.CtyunUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CtyunSmsImpl
extends AbstractSmsBlend {
    private static final Logger log = LoggerFactory.getLogger(CtyunSmsImpl.class);
    private final CtyunConfig ctyunConfig;

    public CtyunSmsImpl(CtyunConfig ctyunConfig, Executor pool, DelayedTime delayedTime) {
        super(pool, delayedTime);
        this.ctyunConfig = ctyunConfig;
    }

    @Restricted
    public SmsResponse sendMessage(String phone, String message) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(this.ctyunConfig.getTemplateName(), message);
        return this.sendMessage(phone, this.ctyunConfig.getTemplateId(), map);
    }

    @Restricted
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        String messageStr = JSONUtil.toJsonStr(messages);
        return this.getSmsResponse(phone, messageStr, templateId);
    }

    @Restricted
    public SmsResponse massTexting(List<String> phones, String message) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(this.ctyunConfig.getTemplateName(), message);
        return this.massTexting(phones, this.ctyunConfig.getTemplateId(), map);
    }

    @Restricted
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        String messageStr = JSONUtil.toJsonStr(messages);
        return this.getSmsResponse(SmsUtil.arrayToString(phones), messageStr, templateId);
    }

    private SmsResponse getSmsResponse(String phone, String message, String templateId) {
        String paramStr;
        String requestUrl;
        AtomicReference smsResponse = new AtomicReference();
        try {
            requestUrl = this.ctyunConfig.getRequestUrl();
            paramStr = CtyunUtils.generateParamJsonStr(this.ctyunConfig, phone, message, templateId);
        }
        catch (Exception e) {
            log.error("ctyun send message error", (Throwable)e);
            throw new SmsBlendException(e.getMessage());
        }
        log.debug("requestUrl {}", (Object)requestUrl);
        this.http.post(requestUrl).addHeader(CtyunUtils.signHeader(paramStr, this.ctyunConfig.getAccessKeyId(), this.ctyunConfig.getAccessKeySecret())).addBody(paramStr).onSuccess((data, req, res) -> smsResponse.set(this.getResponse((JSONObject)res.get(JSONObject.class)))).onError((ex, req, res) -> smsResponse.set(this.getResponse((JSONObject)res.get(JSONObject.class)))).execute();
        return (SmsResponse)smsResponse.get();
    }

    private SmsResponse getResponse(JSONObject resJson) {
        SmsResponse smsResponse = new SmsResponse();
        smsResponse.setCode(resJson.getStr((Object)"code"));
        smsResponse.setMessage(resJson.getStr((Object)"message"));
        smsResponse.setBizId(resJson.getStr((Object)"requestId"));
        smsResponse.setSuccess("OK".equals(smsResponse.getCode()));
        return smsResponse;
    }
}

