/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.huawei.config;

import org.dromara.sms4j.comm.factory.BeanFactory;
import org.dromara.sms4j.huawei.config.HuaweiConfig;
import org.dromara.sms4j.huawei.service.HuaweiSmsImpl;
import org.dromara.sms4j.provider.base.BaseProviderFactory;

public class HuaweiFactory
implements BaseProviderFactory<HuaweiSmsImpl, HuaweiConfig> {
    private static HuaweiSmsImpl huaweiSms;
    private static final HuaweiFactory INSTANCE;

    private HuaweiFactory() {
    }

    public static HuaweiFactory instance() {
        return INSTANCE;
    }

    @Override
    public HuaweiSmsImpl createSms(HuaweiConfig huaweiConfig) {
        if (huaweiSms == null) {
            huaweiSms = this.createMultitonSms(huaweiConfig);
        }
        return huaweiSms;
    }

    @Override
    public HuaweiSmsImpl createMultitonSms(HuaweiConfig huaweiConfig) {
        return new HuaweiSmsImpl(huaweiConfig, BeanFactory.getExecutor(), BeanFactory.getDelayedTime());
    }

    @Override
    public HuaweiSmsImpl refresh(HuaweiConfig huaweiConfig) {
        huaweiSms = new HuaweiSmsImpl(huaweiConfig, BeanFactory.getExecutor(), BeanFactory.getDelayedTime());
        return huaweiSms;
    }

    @Override
    public HuaweiConfig getConfig() {
        return ConfigHolder.config;
    }

    @Override
    public void setConfig(HuaweiConfig config) {
        ConfigHolder.config = config;
    }

    static {
        INSTANCE = new HuaweiFactory();
    }

    private static final class ConfigHolder {
        private static HuaweiConfig config = HuaweiConfig.builder().build();

        private ConfigHolder() {
        }
    }
}

