/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.jdcloud.service;

import cn.hutool.core.util.IdUtil;
import com.jdcloud.sdk.service.sms.client.SmsClient;
import com.jdcloud.sdk.service.sms.model.BatchSendRequest;
import com.jdcloud.sdk.service.sms.model.BatchSendResult;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.dromara.sms4j.api.AbstractSmsBlend;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.comm.annotation.Restricted;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.jdcloud.config.JdCloudConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdCloudSmsImpl
extends AbstractSmsBlend {
    private static final Logger log = LoggerFactory.getLogger(JdCloudSmsImpl.class);
    private final SmsClient client;
    private final JdCloudConfig config;

    public JdCloudSmsImpl(SmsClient client, JdCloudConfig config, Executor pool, DelayedTime delayed) {
        super(pool, delayed);
        this.client = client;
        this.config = config;
    }

    @Restricted
    public SmsResponse sendMessage(String phone, String message) {
        return this.massTexting(Collections.singletonList(phone), message);
    }

    @Restricted
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        return this.massTexting(Collections.singletonList(phone), templateId, messages);
    }

    @Restricted
    public SmsResponse massTexting(List<String> phones, String message) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(IdUtil.fastSimpleUUID(), message);
        return this.massTexting(phones, this.config.getTemplateId(), map);
    }

    @Restricted
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        try {
            BatchSendRequest request = new BatchSendRequest();
            request.setPhoneList(phones);
            request.setRegionId(this.config.getRegion());
            request.setTemplateId(templateId);
            request.setSignId(this.config.getSignature());
            List params = messages.keySet().stream().map(messages::get).collect(Collectors.toList());
            request.setParams(params);
            BatchSendResult result = (BatchSendResult)this.client.batchSend(request).getResult();
            return this.getSmsResponse(result);
        }
        catch (Exception e) {
            throw new SmsBlendException(e.getMessage());
        }
    }

    private SmsResponse getSmsResponse(BatchSendResult res) {
        SmsResponse smsResponse = new SmsResponse();
        smsResponse.setBizId(res.getData().getSequenceNumber());
        smsResponse.setData((Object)res.getData());
        smsResponse.setCode(String.valueOf(res.getCode()));
        smsResponse.setMessage(res.getMessage());
        Boolean status = res.getStatus();
        boolean isSuccess = status != null && status != false;
        smsResponse.setSuccess(isSuccess);
        if (!isSuccess) {
            smsResponse.setErrMessage(res.getMessage());
            smsResponse.setErrorCode(String.valueOf(res.getCode()));
        }
        return smsResponse;
    }
}

