/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.unisms.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.AbstractSmsBlend;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.comm.annotation.Restricted;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.unisms.config.UniConfig;
import org.dromara.sms4j.unisms.core.Uni;
import org.dromara.sms4j.unisms.core.UniResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniSmsImpl
extends AbstractSmsBlend {
    private static final Logger log = LoggerFactory.getLogger(UniSmsImpl.class);
    private final UniConfig config;

    public UniSmsImpl(UniConfig config, Executor pool, DelayedTime delayed) {
        super(pool, delayed);
        this.config = config;
    }

    @Restricted
    public SmsResponse sendMessage(String phone, String message) {
        if ("".equals(this.config.getTemplateId()) && "".equals(this.config.getTemplateName())) {
            throw new SmsBlendException("\u914d\u7f6e\u6587\u4ef6\u6a21\u677fid\u548c\u6a21\u677f\u53d8\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(this.config.getTemplateName(), message);
        return this.sendMessage(phone, this.config.getTemplateId(), map);
    }

    @Restricted
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("to", Collections.singletonList(phone));
        data.put("signature", this.config.getSignature());
        data.put("templateId", templateId);
        data.put("templateData", messages);
        return this.getSmsResponse(data);
    }

    @Restricted
    public SmsResponse massTexting(List<String> phones, String message) {
        if ("".equals(this.config.getTemplateId()) && "".equals(this.config.getTemplateName())) {
            throw new SmsBlendException("\u914d\u7f6e\u6587\u4ef6\u6a21\u677fid\u548c\u6a21\u677f\u53d8\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(this.config.getTemplateName(), message);
        return this.massTexting(phones, this.config.getTemplateId(), map);
    }

    @Restricted
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        if (phones.size() > 1000) {
            throw new SmsBlendException("\u5355\u6b21\u53d1\u9001\u8d85\u8fc7\u6700\u5927\u53d1\u9001\u4e0a\u9650\uff0c\u5efa\u8bae\u6bcf\u6b21\u7fa4\u53d1\u77ed\u4fe1\u4eba\u6570\u4f4e\u4e8e1000");
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("to", phones);
        data.put("signature", this.config.getSignature());
        data.put("templateId", templateId);
        data.put("templateData", messages);
        return this.getSmsResponse(data);
    }

    private SmsResponse getSmsResponse(Map<String, Object> data) {
        SmsResponse smsResponse = new SmsResponse();
        try {
            UniResponse send = Uni.getClient().request("sms.message.send", data);
            smsResponse.setCode(String.valueOf(send.status));
            smsResponse.setErrorCode(send.code);
            smsResponse.setMessage(send.message);
            smsResponse.setBizId(send.requestId);
            smsResponse.setData((Object)send);
            smsResponse.setSuccess("Success".equals(send.message));
        }
        catch (Exception e) {
            smsResponse.setErrMessage(e.getMessage());
        }
        return smsResponse;
    }
}

