/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.zhutong.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.provider.service.AbstractSmsBlend;
import org.dromara.sms4j.zhutong.config.ZhutongConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZhutongSmsImpl
extends AbstractSmsBlend<ZhutongConfig> {
    private static final Logger log = LoggerFactory.getLogger(ZhutongSmsImpl.class);
    private int retry = 0;

    public ZhutongSmsImpl(ZhutongConfig zhutongConfig, Executor pool, DelayedTime delayedTime) {
        super(zhutongConfig, pool, delayedTime);
    }

    public ZhutongSmsImpl(ZhutongConfig zhutongConfig) {
        super(zhutongConfig);
    }

    public String getSupplier() {
        return "zhutong";
    }

    @Override
    public SmsResponse sendMessage(String phone, String message) {
        ZhutongConfig config = (ZhutongConfig)this.getConfig();
        if (StrUtil.hasBlank((CharSequence[])new CharSequence[]{config.getSignature(), config.getTemplateId(), config.getTemplateName()})) {
            return this.getSmsResponse(phone, message);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(1);
        map.put(config.getTemplateName(), message);
        return this.sendMessage(phone, config.getTemplateId(), map);
    }

    @Override
    public SmsResponse sendMessage(String phone, LinkedHashMap<String, String> messages) {
        if (Objects.isNull(messages)) {
            messages = new LinkedHashMap();
        }
        return this.sendMessage(phone, ((ZhutongConfig)this.getConfig()).getTemplateId(), messages);
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        return this.getSmsResponseTemplate(templateId, phone, messages);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String message) {
        ZhutongConfig config = (ZhutongConfig)this.getConfig();
        if (StrUtil.hasBlank((CharSequence[])new CharSequence[]{config.getSignature(), config.getTemplateId(), config.getTemplateName()})) {
            return this.getSmsResponse(phones, message);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(1);
        map.put(config.getTemplateName(), message);
        return this.massTexting(phones, config.getTemplateId(), map);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        return this.getSmsResponseTemplate(templateId, phones, messages);
    }

    protected SmsResponse getSmsResponse(List<String> phones, String content) {
        SmsResponse smsResponse;
        ZhutongConfig config = (ZhutongConfig)this.getConfig();
        String requestUrl = config.getRequestUrl();
        String username = config.getAccessKeyId();
        String password = config.getAccessKeySecret();
        this.validator(requestUrl, username, password);
        if (CollectionUtil.isEmpty(phones)) {
            throw new SmsBlendException("\u52a9\u901a\u77ed\u4fe1\uff1a\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (phones.size() >= 2000) {
            throw new SmsBlendException("\u52a9\u901a\u77ed\u4fe1\uff1a\u624b\u673a\u53f7\u7801\u6700\u591a\u652f\u63012000\u4e2a\uff01");
        }
        if (StrUtil.isBlank((CharSequence)content)) {
            throw new SmsBlendException("\u52a9\u901a\u77ed\u4fe1\uff1a\u53d1\u9001\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (content.length() >= 1000) {
            throw new SmsBlendException("\u52a9\u901a\u77ed\u4fe1\uff1a\u53d1\u9001\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc71000\u4e2a\u5b57\u7b26\uff01");
        }
        if (!content.contains("\u3010")) {
            throw new SmsBlendException("\u52a9\u901a\u77ed\u4fe1\uff1a\u81ea\u5b9a\u4e49\u77ed\u4fe1\u53d1\u9001\u5185\u5bb9\u5fc5\u987b\u5305\u542b\u7b7e\u540d\u4fe1\u606f\uff0c\u5982\uff1a\u3010\u52a9\u901a\u79d1\u6280\u3011\u60a8\u7684\u9a8c\u8bc1\u7801\u662f8888\uff01");
        }
        String url = requestUrl + "v2/sendSms";
        long tKey = System.currentTimeMillis() / 1000L;
        HashMap<String, String> json = new HashMap<String, String>(5);
        json.put("username", username);
        json.put("password", SecureUtil.md5((String)(SecureUtil.md5((String)password) + tKey)));
        json.put("tKey", tKey + "");
        json.put("mobile", StrUtil.join((CharSequence)",", phones));
        json.put("content", content);
        HashMap headers = MapUtil.newHashMap((int)1, (boolean)true);
        headers.put("Content-Type", "application/json; charset=utf-8");
        try {
            smsResponse = this.getResponse(this.http.postJson(requestUrl, (Map)headers, json));
        }
        catch (SmsBlendException e) {
            smsResponse = new SmsResponse();
            smsResponse.setSuccess(false);
            smsResponse.setData((Object)e.getMessage());
        }
        if (smsResponse.isSuccess() || this.retry == ((ZhutongConfig)this.getConfig()).getMaxRetries()) {
            this.retry = 0;
            return smsResponse;
        }
        return this.requestRetry(phones, content);
    }

    private SmsResponse requestRetry(List<String> phones, String content) {
        this.http.safeSleep(((ZhutongConfig)this.getConfig()).getRetryInterval());
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c {" + this.retry + "} \u6b21\u91cd\u65b0\u53d1\u9001");
        return this.getSmsResponse(phones, content);
    }

    protected SmsResponse getSmsResponse(String mobile, String content) {
        return this.getSmsResponse(ListUtil.of((Object[])new String[]{mobile}), content);
    }

    protected SmsResponse getSmsResponseTemplate(String templateId, List<String> phones, LinkedHashMap<String, String> messages) {
        SmsResponse smsResponse;
        ZhutongConfig config = (ZhutongConfig)this.getConfig();
        String requestUrl = config.getRequestUrl();
        String username = config.getAccessKeyId();
        String password = config.getAccessKeySecret();
        String signature = config.getSignature();
        this.validator(requestUrl, username, password);
        if (StrUtil.isBlank((CharSequence)signature)) {
            throw new SmsBlendException("\u52a9\u901a\u77ed\u4fe1\uff1a\u6a21\u677f\u77ed\u4fe1\u4e2d\u5df2\u62a5\u5907\u7684\u7b7e\u540dsignature\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!signature.startsWith("\u3010")) {
            signature = "\u3010" + signature;
        }
        if (!signature.endsWith("\u3011")) {
            signature = signature + "\u3011";
        }
        if (StrUtil.isBlank((CharSequence)templateId)) {
            throw new SmsBlendException("\u52a9\u901a\u77ed\u4fe1\uff1a\u6a21\u677f\u77ed\u4fe1\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01");
        }
        String url = requestUrl + "v2/sendSmsTp";
        JSONObject requestJson = new JSONObject();
        requestJson.set("username", (Object)username);
        long tKey = System.currentTimeMillis() / 1000L;
        requestJson.set("tKey", (Object)tKey);
        requestJson.set("password", (Object)SecureUtil.md5((String)(SecureUtil.md5((String)password) + tKey)));
        requestJson.set("tpId", (Object)templateId);
        requestJson.set("signature", (Object)signature);
        requestJson.set("ext", (Object)"");
        requestJson.set("extend", (Object)"");
        JSONArray records = new JSONArray();
        for (String mobile : phones) {
            JSONObject record = new JSONObject();
            record.set("mobile", (Object)mobile);
            JSONObject param = new JSONObject();
            param.putAll(messages);
            record.set("tpContent", (Object)param);
            records.add((Object)record);
        }
        requestJson.set("records", (Object)records);
        HashMap headers = MapUtil.newHashMap((int)1, (boolean)true);
        headers.put("Content-Type", "application/json; charset=utf-8");
        try {
            smsResponse = this.getResponse(this.http.postJson(requestUrl, (Map)headers, requestJson.toString()));
        }
        catch (SmsBlendException e) {
            smsResponse = new SmsResponse();
            smsResponse.setSuccess(false);
            smsResponse.setData((Object)e.getMessage());
        }
        if (smsResponse.isSuccess() || this.retry == ((ZhutongConfig)this.getConfig()).getMaxRetries()) {
            this.retry = 0;
            return smsResponse;
        }
        return this.requestRetry(templateId, phones, messages);
    }

    private SmsResponse requestRetry(String templateId, List<String> phones, LinkedHashMap<String, String> messages) {
        this.http.safeSleep(((ZhutongConfig)this.getConfig()).getRetryInterval());
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c {" + this.retry + "} \u6b21\u91cd\u65b0\u53d1\u9001");
        return this.getSmsResponseTemplate(templateId, phones, messages);
    }

    protected SmsResponse getSmsResponseTemplate(String templateId, String mobile, LinkedHashMap<String, String> content) {
        return this.getSmsResponseTemplate(templateId, ListUtil.of((Object[])new String[]{mobile}), content);
    }

    private SmsResponse getResponse(JSONObject jsonObject) {
        SmsResponse smsResponse = new SmsResponse();
        smsResponse.setSuccess(jsonObject.getInt((Object)"code", Integer.valueOf(-1)) <= 200);
        smsResponse.setData((Object)jsonObject);
        smsResponse.setConfigId(this.getConfigId());
        return smsResponse;
    }

    private void validator(String requestUrl, String username, String password) {
        if (StrUtil.isBlank((CharSequence)requestUrl)) {
            throw new SmsBlendException("\u52a9\u901a\u77ed\u4fe1\uff1arequestUrl\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!requestUrl.endsWith("/")) {
            throw new SmsBlendException("\u52a9\u901a\u77ed\u4fe1\uff1arequestUrl\u5fc5\u987b\u4ee5'/'\u7ed3\u5c3e!");
        }
        if (StrUtil.hasBlank((CharSequence[])new CharSequence[]{username, password})) {
            throw new SmsBlendException("\u52a9\u901a\u77ed\u4fe1\uff1a\u8d26\u53f7username\u3001\u5bc6\u7801password\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

