/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.aliyun.service;

import cn.hutool.core.map.MapUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.dromara.sms4j.aliyun.config.AlibabaConfig;
import org.dromara.sms4j.aliyun.utils.AliyunUtils;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.dromara.sms4j.provider.service.AbstractSmsBlend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlibabaSmsImpl
extends AbstractSmsBlend<AlibabaConfig> {
    private static final Logger log = LoggerFactory.getLogger(AlibabaSmsImpl.class);
    private int retry = 0;

    public AlibabaSmsImpl(AlibabaConfig config, Executor pool, DelayedTime delayedTime) {
        super(config, pool, delayedTime);
    }

    public AlibabaSmsImpl(AlibabaConfig config) {
        super(config);
    }

    public String getSupplier() {
        return "alibaba";
    }

    @Override
    public SmsResponse sendMessage(String phone, String message) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(((AlibabaConfig)this.getConfig()).getTemplateName(), message);
        return this.sendMessage(phone, ((AlibabaConfig)this.getConfig()).getTemplateId(), map);
    }

    @Override
    public SmsResponse sendMessage(String phone, LinkedHashMap<String, String> messages) {
        if (Objects.isNull(messages)) {
            messages = new LinkedHashMap();
        }
        return this.sendMessage(phone, ((AlibabaConfig)this.getConfig()).getTemplateId(), messages);
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        if (Objects.isNull(messages)) {
            messages = new LinkedHashMap();
        }
        String messageStr = JSONUtil.toJsonStr(messages);
        return this.getSmsResponse(phone, messageStr, templateId);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String message) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(((AlibabaConfig)this.getConfig()).getTemplateName(), message);
        return this.massTexting(phones, ((AlibabaConfig)this.getConfig()).getTemplateId(), map);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        if (Objects.isNull(messages)) {
            messages = new LinkedHashMap();
        }
        String messageStr = JSONUtil.toJsonStr(messages);
        return this.getSmsResponse(SmsUtils.arrayToString(phones), messageStr, templateId);
    }

    private SmsResponse getSmsResponse(String phone, String message, String templateId) {
        SmsResponse smsResponse;
        String paramStr;
        String requestUrl;
        try {
            requestUrl = AliyunUtils.generateSendSmsRequestUrl((AlibabaConfig)this.getConfig(), message, phone, templateId);
            paramStr = AliyunUtils.generateParamBody((AlibabaConfig)this.getConfig(), phone, message, templateId);
        }
        catch (Exception e) {
            log.error("aliyun send message error", (Throwable)e);
            throw new SmsBlendException(e.getMessage());
        }
        log.debug("requestUrl {}", (Object)requestUrl);
        HashMap headers = MapUtil.newHashMap((int)1, (boolean)true);
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        try {
            smsResponse = this.getResponse(this.http.postJson(requestUrl, (Map)headers, paramStr));
        }
        catch (SmsBlendException e) {
            smsResponse = new SmsResponse();
            smsResponse.setSuccess(false);
            smsResponse.setData((Object)e.getMessage());
        }
        if (smsResponse.isSuccess() || this.retry == ((AlibabaConfig)this.getConfig()).getMaxRetries()) {
            this.retry = 0;
            return smsResponse;
        }
        return this.requestRetry(phone, message, templateId);
    }

    private SmsResponse requestRetry(String phone, String message, String templateId) {
        this.http.safeSleep(((AlibabaConfig)this.getConfig()).getRetryInterval());
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c {} \u6b21\u91cd\u65b0\u53d1\u9001", (Object)this.retry);
        return this.getSmsResponse(phone, message, templateId);
    }

    private SmsResponse getResponse(JSONObject resJson) {
        SmsResponse smsResponse = new SmsResponse();
        smsResponse.setSuccess("OK".equals(resJson.getStr((Object)"Code")));
        smsResponse.setData((Object)resJson);
        smsResponse.setConfigId(this.getConfigId());
        return smsResponse;
    }
}

