/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.streamquery.stream.core.async;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.dromara.streamquery.stream.core.async.AsyncConfig;
import org.dromara.streamquery.stream.core.async.AsyncInterceptor;
import org.dromara.streamquery.stream.core.lambda.function.SerSupp;
import org.dromara.streamquery.stream.core.stream.Steam;

public class AsyncHelper {
    private static final AsyncConfig DEFAULT_CONFIG = AsyncConfig.create();

    private AsyncHelper() {
    }

    @SafeVarargs
    public static <T> List<T> supply(SerSupp<T> ... suppliers) {
        return AsyncHelper.supply(DEFAULT_CONFIG, suppliers);
    }

    @SafeVarargs
    public static <T> List<T> supply(AsyncConfig asyncConfig, SerSupp<T> ... suppliers) {
        AsyncInterceptor interceptor = asyncConfig.getInterceptor();
        interceptor.before();
        CompletableFuture[] futures = (CompletableFuture[])((Steam)Steam.of(suppliers).map(supplier -> CompletableFuture.supplyAsync(() -> interceptor.execute(supplier), asyncConfig.getExecutor()))).toArray(CompletableFuture[]::new);
        CompletionStage exceptionally = CompletableFuture.allOf(futures).exceptionally(interceptor::onError);
        ((SerSupp<Object>)() -> AsyncHelper.lambda$supply$821e74b7$1(asyncConfig, (CompletableFuture)exceptionally)).get();
        interceptor.after();
        return Steam.of(futures).map(CompletableFuture::get).toList();
    }

    private static /* synthetic */ Object lambda$supply$821e74b7$1(AsyncConfig asyncConfig, CompletableFuture exceptionally) throws Throwable {
        return asyncConfig.getTimeout() == -1 ? exceptionally.get() : exceptionally.get(asyncConfig.getTimeout(), asyncConfig.getTimeUnit());
    }
}

