/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.streamquery.stream.core.business.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.dromara.streamquery.stream.core.lambda.LambdaHelper;
import org.dromara.streamquery.stream.core.lambda.function.SerBiCons;
import org.dromara.streamquery.stream.core.lambda.function.SerCons;
import org.dromara.streamquery.stream.core.lambda.function.SerFunc;
import org.dromara.streamquery.stream.core.lambda.function.SerPred;
import org.dromara.streamquery.stream.core.optional.Opp;
import org.dromara.streamquery.stream.core.stream.Steam;

public class TreeHelper<T, R extends Comparable<? super R>> {
    private final SerFunc<T, R> idGetter;
    private final SerFunc<T, R> pidGetter;
    private final R pidValue;
    private final SerPred<T> parentPredicate;
    private final SerFunc<T, List<T>> childrenGetter;
    private SerBiCons<T, List<T>> childrenSetter;

    public SerBiCons<T, List<T>> getChildrenSetter() {
        return this.childrenSetter;
    }

    public void setChildrenSetter(SerBiCons<T, List<T>> childrenSetter) {
        this.childrenSetter = childrenSetter;
    }

    private TreeHelper(SerFunc<T, R> idGetter, SerFunc<T, R> pidGetter, R pidValue, SerPred<T> parentPredicate, SerFunc<T, List<T>> childrenGetter, SerBiCons<T, List<T>> childrenSetter) {
        this.idGetter = idGetter;
        this.pidGetter = pidGetter;
        this.pidValue = pidValue;
        this.parentPredicate = parentPredicate;
        this.childrenGetter = childrenGetter;
        this.childrenSetter = Opp.of(childrenSetter).orElseGet(() -> LambdaHelper.getSetter(childrenGetter));
    }

    @Deprecated
    public static <T, R extends Comparable<? super R>> TreeHelper<T, R> of(SerFunc<T, R> idGetter, SerFunc<T, R> pidGetter, R pidValue, SerFunc<T, List<T>> childrenGetter, SerBiCons<T, List<T>> childrenSetter) {
        return new TreeHelper<T, R>(idGetter, pidGetter, pidValue, null, childrenGetter, childrenSetter);
    }

    public static <T, R extends Comparable<? super R>> TreeHelper<T, R> of(SerFunc<T, R> idGetter, SerFunc<T, R> pidGetter, R pidValue, SerFunc<T, List<T>> childrenGetter) {
        return new TreeHelper<T, R>(idGetter, pidGetter, pidValue, null, childrenGetter, null);
    }

    @Deprecated
    public static <T, R extends Comparable<? super R>> TreeHelper<T, R> ofMatch(SerFunc<T, R> idGetter, SerFunc<T, R> pidGetter, SerPred<T> parentPredicate, SerFunc<T, List<T>> childrenGetter, SerBiCons<T, List<T>> childrenSetter) {
        return new TreeHelper<T, Object>(idGetter, pidGetter, null, parentPredicate, childrenGetter, childrenSetter);
    }

    public static <T, R extends Comparable<? super R>> TreeHelper<T, R> ofMatch(SerFunc<T, R> idGetter, SerFunc<T, R> pidGetter, SerPred<T> parentPredicate, SerFunc<T, List<T>> childrenGetter) {
        return new TreeHelper<T, Object>(idGetter, pidGetter, null, parentPredicate, childrenGetter, null);
    }

    public List<T> toTree(List<T> list) {
        return this.toTree(list, null, null);
    }

    public List<T> toTree(List<T> list, SerBiCons<T, Integer> levelSetter) {
        return this.toTree(list, null, levelSetter);
    }

    public List<T> toTree(List<T> list, Integer level, SerBiCons<T, Integer> levelSetter) {
        if (level != null && level < 0) {
            return new ArrayList();
        }
        if (Objects.isNull(this.parentPredicate)) {
            Map<R, List<T>> pIdValuesMap = Steam.of(list).filter(e -> Objects.nonNull(this.idGetter.apply(e))).group(this.pidGetter);
            List parents = pIdValuesMap.getOrDefault(this.pidValue, new ArrayList());
            return this.getTreeSet(level, pIdValuesMap, parents, levelSetter);
        }
        ArrayList parents = new ArrayList(list.size());
        Map<R, List<T>> pIdValuesMap = Steam.of(list).filter(e -> {
            if (this.parentPredicate.test(e)) {
                parents.add(e);
            }
            return Objects.nonNull(this.idGetter.apply(e));
        }).group(this.pidGetter);
        return this.getTreeSet(level, pIdValuesMap, parents, levelSetter);
    }

    private List<T> getTreeSet(Integer level, Map<R, List<T>> pIdValuesMap, List<T> parents, SerBiCons<T, Integer> levelSetter) {
        for (T parent : parents) {
            if (null != levelSetter) {
                levelSetter.accept(parent, 0);
            }
            this.getChildrenFromMapByPidAndSet(pIdValuesMap, parent, level == null ? Integer.MAX_VALUE : level, 0, levelSetter);
        }
        return parents;
    }

    private void getChildrenFromMapByPidAndSet(Map<R, List<T>> pIdValuesMap, T parent, Integer level, Integer currentLevel, SerBiCons<T, Integer> levelSetter) {
        if (currentLevel >= level) {
            return;
        }
        List<T> children = pIdValuesMap.get(this.idGetter.apply(parent));
        if (Opp.ofColl(children).isEmpty()) {
            return;
        }
        this.childrenSetter.accept(parent, children);
        for (T child : children) {
            if (null != levelSetter) {
                levelSetter.accept(child, currentLevel + 1);
            }
            this.getChildrenFromMapByPidAndSet(pIdValuesMap, child, level, currentLevel + 1, levelSetter);
        }
    }

    public List<T> flat(List<T> list) {
        AtomicReference<Function<Object, Steam>> recursiveRef = new AtomicReference<Function<Object, Steam>>();
        Function<Object, Steam> recursive = e -> Steam.of((Iterable)this.childrenGetter.apply(e)).flat((Function)recursiveRef.get()).unshift(e);
        recursiveRef.set(recursive);
        return Steam.of(list).flat(recursive).peek(e -> this.childrenSetter.accept(e, null)).toList();
    }

    public List<T> filter(List<T> list, SerPred<T> condition) {
        AtomicReference recursiveRef = new AtomicReference();
        SerPred[] serPredArray = new SerPred[2];
        serPredArray[0] = condition::test;
        serPredArray[1] = e -> Opp.ofColl((Collection)this.childrenGetter.apply(e)).map(children -> Steam.of(children).filter((Predicate)recursiveRef.get()).toList()).peek(children -> this.childrenSetter.accept(e, (List<Object>)children)).is(s -> !s.isEmpty());
        SerPred recursive = SerPred.multiOr(serPredArray);
        recursiveRef.set(recursive);
        return Steam.of(list).filter((Predicate)recursive).toList();
    }

    public List<T> forEach(List<T> list, SerCons<T> action) {
        AtomicReference recursiveRef = new AtomicReference();
        SerCons[] serConsArray = new SerCons[2];
        serConsArray[0] = action::accept;
        serConsArray[1] = e -> Opp.ofColl((Collection)this.childrenGetter.apply(e)).peek(children -> Steam.of(children).forEach((Consumer)recursiveRef.get()));
        SerCons recursive = SerCons.multi(serConsArray);
        recursiveRef.set(recursive);
        Steam.of(list).forEach(recursive);
        return list;
    }

    public int getDepth(T node) {
        LinkedList<T> queue = new LinkedList<T>();
        queue.offer(node);
        int maxDepth = 0;
        while (!Opp.ofColl(queue).isEmpty()) {
            for (int i = 0; i < queue.size(); ++i) {
                Steam.of((Iterable)this.childrenGetter.apply(queue.poll())).forEach(queue::offer);
            }
            ++maxDepth;
        }
        return maxDepth;
    }
}

