/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.streamquery.stream.core.clazz;

import java.io.File;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.dromara.streamquery.stream.core.lambda.function.SerPred;
import org.dromara.streamquery.stream.core.lambda.function.SerSupp;
import org.dromara.streamquery.stream.core.reflect.ReflectHelper;
import org.dromara.streamquery.stream.core.stream.Steam;

public class ClassHelper {
    private ClassHelper() {
    }

    public static List<Class<?>> scanClasses(String packageName) {
        String packagePath = packageName.replace(".", "/");
        Enumeration resources = ((SerSupp<Enumeration>)() -> Thread.currentThread().getContextClassLoader().getResources(packagePath)).get();
        return ((Steam)((Steam)Steam.of(Collections.list(resources)).flat(url -> {
            if ("file".equals(url.getProtocol())) {
                File dir = new File(URLDecoder.decode(url.getFile(), StandardCharsets.UTF_8.name()));
                if (!dir.exists() || !dir.isDirectory()) {
                    return null;
                }
                return ((Steam)((Steam)((Steam)Steam.of(dir.listFiles()).map(File::getName)).filter(path -> path.endsWith(".class"))).map(path -> path.substring(path.lastIndexOf(File.separatorChar) + 1, path.length() - 6))).map(name -> packageName + "." + name);
            }
            JarURLConnection urlConnection = (JarURLConnection)url.openConnection();
            JarFile jarFile = urlConnection.getJarFile();
            return ((Steam)((Steam)Steam.of(Collections.list(jarFile.entries())).filter((Predicate)SerPred.multiAnd(e -> e.getName().startsWith(packagePath), e -> e.getName().endsWith(".class"), e -> !e.isDirectory()))).map(ZipEntry::getName)).map(name -> name.substring(0, name.length() - 6).replace(File.separator, "."));
        }).filter(className -> !className.contains("$"))).map(ReflectHelper::loadClass)).filter(clazz -> !Modifier.isAbstract(clazz.getModifiers()) && !Modifier.isInterface(clazz.getModifiers())).toList();
    }
}

