/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.streamquery.stream.core.collection;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.dromara.streamquery.stream.core.enums.JreEnum;
import org.dromara.streamquery.stream.core.lambda.function.SerThiFunc;
import org.dromara.streamquery.stream.core.optional.Opp;
import org.dromara.streamquery.stream.core.stream.Steam;
import org.dromara.streamquery.stream.core.stream.collector.Collective;
import org.dromara.streamquery.stream.core.variable.VariableHelper;

public class Maps {
    private Maps() {
    }

    public static <K, V> Map<K, V> of() {
        return new HashMap(16);
    }

    public static <K, V> Map<K, V> ofSize(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    public static <K, V> Map<K, V> of(K k, V v) {
        Map<K, V> map = Maps.ofSize(1);
        map.put(k, v);
        return map;
    }

    public static <K, V> Map<K, V> of(K k, V v, K k1, V v1) {
        Map<K, V> map = Maps.ofSize(2);
        map.put(k, v);
        map.put(k1, v1);
        return map;
    }

    public static <K, V> Map<K, V> of(K k, V v, K k1, V v1, K k2, V v2) {
        Map<K, V> map = Maps.ofSize(4);
        map.put(k, v);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }

    @SafeVarargs
    public static <K, A, V, C extends Collection<A>> Steam<Map.Entry<K, List<V>>> oneToManyToOne(Map<K, C> middleMap, Map<A, V> attachMap, UnaryOperator<Steam<V>> ... unaryOperator) {
        return Steam.of(middleMap.entrySet()).map(e -> Maps.entry(e.getKey(), ((Steam)VariableHelper.first(unaryOperator, UnaryOperator::identity).apply(Steam.of((Iterable)e.getValue()).map(attachMap::get))).toList()));
    }

    @SafeVarargs
    public static <K, A, V> Steam<Map.Entry<K, V>> oneToOneToOne(Map<K, A> middleMap, Map<A, V> attachMap, UnaryOperator<V> ... unaryOperator) {
        return Steam.of(middleMap.entrySet()).map(e -> Maps.entry(e.getKey(), VariableHelper.first(unaryOperator, UnaryOperator::identity).apply(attachMap.get(e.getValue()))));
    }

    @SafeVarargs
    public static <K, A, V> Steam<Map.Entry<K, List<V>>> oneToOneToMany(Map<K, A> middleMap, Map<A, List<V>> attachMap, UnaryOperator<Steam<V>> ... unaryOperator) {
        return Steam.of(middleMap.entrySet()).map(e -> Maps.entry(e.getKey(), ((Steam)VariableHelper.first(unaryOperator, UnaryOperator::identity).apply(Steam.of(e.getValue()).flat(attachMap::get))).toList()));
    }

    public static <K, V> Map<K, V> empty() {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> merge(Map<K, V> m1, Map<K, V> m2, SerThiFunc<K, V, V, V> mergeFunction) {
        HashMap result = new HashMap(m1);
        m2.forEach((key, value) -> result.merge(key, value, (v1, v2) -> mergeFunction.apply(key, v1, v2)));
        return result;
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, BiPredicate<K, V> biPredicate) {
        return ((Steam)Steam.of(map.entrySet()).filter(e -> biPredicate.test(e.getKey(), e.getValue()))).collect(Collective.entryToMap());
    }

    public static <K, V> Map<String, V> flatten(Map<String, Map<String, V>> nestedMap, String delimiter) {
        return Steam.of(nestedMap.entrySet()).flat(entry -> Steam.of(((Map)entry.getValue()).entrySet()).map(innerEntry -> Maps.entry((String)entry.getKey() + delimiter + (String)innerEntry.getKey(), innerEntry.getValue()))).collect(Collective.entryToMap());
    }

    public static <K, V> V computeIfAbsent(Map<K, V> map, K key, Function<? super K, ? extends V> mappingFunction) {
        if (JreEnum.JAVA_8.isCurrentVersion() && map instanceof ConcurrentHashMap) {
            return (V)Opp.of(map.get(key)).orElseGet(() -> {
                Object value = mappingFunction.apply((Object)key);
                map.put((Object)key, (Object)value);
                return value;
            });
        }
        return map.computeIfAbsent((K)key, mappingFunction);
    }
}

