/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.streamquery.stream.core.enums;

import java.util.logging.Logger;
import org.dromara.streamquery.stream.core.reflect.ReflectHelper;

public enum JreEnum {
    JAVA_8,
    JAVA_9,
    JAVA_10,
    JAVA_11,
    JAVA_12,
    JAVA_13,
    JAVA_14,
    JAVA_15,
    JAVA_16,
    JAVA_17,
    JAVA_18,
    JAVA_19;

    private static final Logger LOGGER;
    private static final JreEnum VERSION;
    public static final String DEFAULT_JAVA_VERSION = "1.8";

    public static JreEnum currentVersion() {
        return VERSION;
    }

    public boolean isCurrentVersion() {
        return this == VERSION;
    }

    private static JreEnum getJre() {
        boolean isBlank;
        String version = System.getProperty("java.version");
        boolean bl = isBlank = version == null || version.trim().length() == 0;
        if (isBlank) {
            LOGGER.info("java.version is blank");
        }
        if (!isBlank && version.startsWith(DEFAULT_JAVA_VERSION)) {
            return JAVA_8;
        }
        try {
            Object javaRunTimeVersion = ReflectHelper.invoke(Runtime.getRuntime(), ReflectHelper.getMethod(Runtime.class, "version", new Class[0]), new Object[0]);
            int majorVersion = (Integer)ReflectHelper.invoke(javaRunTimeVersion, ReflectHelper.getMethod(javaRunTimeVersion.getClass(), "major", new Class[0]), new Object[0]);
            return JreEnum.valueOf("JAVA_" + majorVersion);
        }
        catch (Exception ignore) {
            LOGGER.info("can't determine current JRE version");
            return JAVA_8;
        }
    }

    static {
        LOGGER = Logger.getAnonymousLogger();
        VERSION = JreEnum.getJre();
    }
}

